/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestClient
extends RestHighLevelClient {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestClient.class);

    public ElasticSearchRestClient(RestClient restClient) {
        super(restClient);
    }

    public final boolean refresh(String indexName, Header ... headers) {
        try {
            return (Boolean)this.performRequest((ActionRequest)new MainRequest(), request -> ElasticSearchRestClient.refresh(indexName), ElasticSearchRestClient::convertResponse, Collections.emptySet(), headers);
        }
        catch (IOException e) {
            logger.info("Failed to refresh index \"{}\"", (Object)indexName, (Object)e);
            return false;
        }
    }

    private static Request refresh(String indexName) {
        return new Request("POST", "/" + indexName + "/_refresh", Collections.emptyMap(), null);
    }

    public final boolean delete(String indexName, Header ... headers) throws IOException {
        return (Boolean)this.performRequest((ActionRequest)new MainRequest(), request -> ElasticSearchRestClient.delete(indexName), ElasticSearchRestClient::convertResponse, Collections.emptySet(), headers);
    }

    private static Request delete(String indexName) {
        return new Request("DELETE", "/" + indexName, Collections.emptyMap(), null);
    }

    public Set<Map.Entry<String, Object>> getMappings(String indexName, Header ... headers) throws IOException {
        return (Set)this.performRequestAndParseEntity((ActionRequest)new GetIndexRequest(), request -> ElasticSearchRestClient.getMappings(indexName), response -> ElasticSearchRestClient.parseMappings(response, indexName), Collections.emptySet(), headers);
    }

    private static Request getMappings(String indexName) {
        return new Request("GET", "/" + indexName, Collections.emptyMap(), null);
    }

    public final boolean createMapping(PutMappingRequest putMappingRequest, Header ... headers) throws IOException {
        return (Boolean)this.performRequest((ActionRequest)putMappingRequest, request -> ElasticSearchRestClient.putMapping(putMappingRequest), ElasticSearchRestClient::convertResponse, Collections.emptySet(), headers);
    }

    private static Request putMapping(PutMappingRequest putMappingRequest) {
        String endpoint = "/" + putMappingRequest.indices()[0] + "/_mapping/" + putMappingRequest.type();
        ByteArrayEntity entity = new ByteArrayEntity(putMappingRequest.source().getBytes(), ContentType.APPLICATION_JSON);
        return new Request("PUT", endpoint, Collections.emptyMap(), (HttpEntity)entity);
    }

    private static boolean convertResponse(Response response) {
        return response.getStatusLine().getStatusCode() == 200;
    }

    static Set<Map.Entry<String, Object>> parseMappings(XContentParser response, String indexName) throws IOException {
        Map schema = (Map)response.map().get(indexName);
        Map tables = (Map)schema.get("mappings");
        return tables.entrySet();
    }

    ActionResponse execute(ActionRequest request) throws IOException {
        if (request instanceof BulkRequest) {
            return this.bulk((BulkRequest)request, new Header[0]);
        }
        if (request instanceof IndexRequest) {
            return this.index((IndexRequest)request, new Header[0]);
        }
        if (request instanceof DeleteRequest) {
            return this.delete((DeleteRequest)request, new Header[0]);
        }
        if (request instanceof ClearScrollRequest) {
            return this.clearScroll((ClearScrollRequest)request, new Header[0]);
        }
        if (request instanceof SearchScrollRequest) {
            return this.searchScroll((SearchScrollRequest)request, new Header[0]);
        }
        return null;
    }
}

