/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.elasticsearch.common.ElasticSearchDateConverter;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.util.NumberComparator;

final class JestElasticSearchUtils {
    JestElasticSearchUtils() {
    }

    public static Row createRow(JsonObject source, String documentId, DataSetHeader header) {
        Object[] values = new Object[header.size()];
        for (int i = 0; i < values.length; ++i) {
            SelectItem selectItem = header.getSelectItem(i);
            Column column = selectItem.getColumn();
            assert (column != null);
            assert (!selectItem.hasFunction());
            values[i] = column.isPrimaryKey() ? documentId : JestElasticSearchUtils.getDataFromColumnType(source.get(column.getName()), column.getType());
        }
        return new DefaultRow(header, values);
    }

    private static Object getDataFromColumnType(JsonElement field, ColumnType type) {
        if (field == null || field.isJsonNull()) {
            return null;
        }
        if (field.isJsonObject()) {
            return new Gson().fromJson(field, Map.class);
        }
        if (field.isJsonArray()) {
            return new Gson().fromJson(field, List.class);
        }
        if (type.isNumber()) {
            return NumberComparator.toNumber((Object)field.getAsString());
        }
        if (type.isTimeBased()) {
            Date valueToDate = ElasticSearchDateConverter.tryToConvert((String)field.getAsString());
            if (valueToDate == null) {
                return field.getAsString();
            }
            return valueToDate;
        }
        if (type.isBoolean()) {
            return field.getAsBoolean();
        }
        return field.getAsString();
    }
}

