/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.SearchScroll;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.elasticsearch.rest.JestClientExecutor;
import org.apache.metamodel.elasticsearch.rest.JestDeleteScroll;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUtils;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JestElasticSearchDataSet
extends AbstractDataSet {
    private static final Logger logger = LoggerFactory.getLogger(JestElasticSearchDataSet.class);
    private final JestClient _client;
    private final AtomicBoolean _closed;
    private JestResult _searchResponse;
    private JsonObject _currentHit;
    private int _hitIndex = 0;

    public JestElasticSearchDataSet(JestClient client, JestResult searchResponse, List<SelectItem> selectItems) {
        super(selectItems);
        this._client = client;
        this._searchResponse = searchResponse;
        this._closed = new AtomicBoolean(false);
    }

    public JestElasticSearchDataSet(JestClient client, JestResult searchResponse, Column[] columns) {
        super(columns);
        this._client = client;
        this._searchResponse = searchResponse;
        this._closed = new AtomicBoolean(false);
    }

    public void close() {
        super.close();
        boolean closeNow = this._closed.compareAndSet(true, false);
        if (closeNow) {
            String scrollId = this._searchResponse.getJsonObject().getAsJsonPrimitive("_scroll_id").getAsString();
            JestClientExecutor.execute(this._client, new JestDeleteScroll.Builder(scrollId).build(), false);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this._closed.get()) {
            logger.warn("finalize() invoked, but DataSet is not closed. Invoking close() on {}", (Object)this);
            this.close();
        }
    }

    public boolean next() {
        JsonArray hits = this._searchResponse.getJsonObject().getAsJsonObject("hits").getAsJsonArray("hits");
        if (hits.size() == 0) {
            this._currentHit = null;
            return false;
        }
        if (this._hitIndex < hits.size()) {
            this._currentHit = hits.get(this._hitIndex).getAsJsonObject();
            ++this._hitIndex;
            return true;
        }
        JsonPrimitive scrollId = this._searchResponse.getJsonObject().getAsJsonPrimitive("_scroll_id");
        if (scrollId == null) {
            this._currentHit = null;
            return false;
        }
        SearchScroll scroll = new SearchScroll.Builder(scrollId.getAsString(), "1m").build();
        this._searchResponse = JestClientExecutor.execute(this._client, scroll);
        this._hitIndex = 0;
        return this.next();
    }

    public Row getRow() {
        if (this._currentHit == null) {
            return null;
        }
        JsonObject source = this._currentHit.getAsJsonObject("_source");
        String documentId = this._currentHit.get("_id").getAsString();
        return JestElasticSearchUtils.createRow(source, documentId, this.getHeader());
    }
}

