/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import org.apache.metamodel.ConnectionException;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.elasticsearch.rest.ElasticSearchRestDataContext;
import org.apache.metamodel.factory.DataContextFactory;
import org.apache.metamodel.factory.DataContextProperties;
import org.apache.metamodel.factory.ResourceFactoryRegistry;
import org.apache.metamodel.factory.UnsupportedDataContextPropertiesException;
import org.apache.metamodel.util.SimpleTableDef;

public class ElasticSearchRestDataContextFactory
implements DataContextFactory {
    public boolean accepts(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) {
        switch (properties.getDataContextType()) {
            case "elasticsearch": {
                String url = properties.getUrl();
                return url != null && url.startsWith("http") && this.acceptsInternal(properties);
            }
            case "es-rest": 
            case "elasticsearch-rest": {
                return this.acceptsInternal(properties);
            }
        }
        return false;
    }

    private boolean acceptsInternal(DataContextProperties properties) {
        if (properties.getUrl() == null) {
            return false;
        }
        return this.getIndex(properties) != null;
    }

    private JestClient createClient(DataContextProperties properties) {
        String serverUri = properties.getUrl();
        HttpClientConfig.Builder builder = new HttpClientConfig.Builder(serverUri);
        if (properties.getUsername() != null) {
            builder.defaultCredentials(properties.getUsername(), properties.getPassword());
        }
        JestClientFactory clientFactory = new JestClientFactory();
        HttpClientConfig httpClientConfig = new HttpClientConfig(builder);
        clientFactory.setHttpClientConfig(httpClientConfig);
        JestClient client = clientFactory.getObject();
        return client;
    }

    private String getIndex(DataContextProperties properties) {
        String databaseName = properties.getDatabaseName();
        if (databaseName == null) {
            properties.toMap().get("index");
        }
        return databaseName;
    }

    public DataContext create(DataContextProperties properties, ResourceFactoryRegistry resourceFactoryRegistry) throws UnsupportedDataContextPropertiesException, ConnectionException {
        JestClient client = this.createClient(properties);
        String indexName = this.getIndex(properties);
        SimpleTableDef[] tableDefinitions = properties.getTableDefs();
        return new ElasticSearchRestDataContext(client, indexName, tableDefinitions);
    }
}

