/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.elasticsearch.rest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.core.Count;
import io.searchbox.core.CountResult;
import io.searchbox.core.Get;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.indices.mapping.GetMapping;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.metamodel.BatchUpdateScript;
import org.apache.metamodel.DataContext;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.elasticsearch.common.ElasticSearchMetaData;
import org.apache.metamodel.elasticsearch.common.ElasticSearchUtils;
import org.apache.metamodel.elasticsearch.rest.JestClientExecutor;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchDataSet;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchMetaDataParser;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUpdateCallback;
import org.apache.metamodel.elasticsearch.rest.JestElasticSearchUtils;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.LogicalOperator;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchRestDataContext
extends QueryPostprocessDataContext
implements DataContext,
UpdateableDataContext {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchRestDataContext.class);
    public static final String FIELD_ID = "_id";
    public static final String TIMEOUT_SCROLL = "1m";
    private static final int SCROLL_THRESHOLD = 400;
    private final JestClient elasticSearchClient;
    private final String indexName;
    private final List<SimpleTableDef> staticTableDefinitions;
    private final List<SimpleTableDef> dynamicTableDefinitions = new ArrayList<SimpleTableDef>();

    public ElasticSearchRestDataContext(JestClient client, String indexName, SimpleTableDef ... tableDefinitions) {
        if (client == null) {
            throw new IllegalArgumentException("ElasticSearch Client cannot be null");
        }
        if (indexName == null || indexName.trim().length() == 0) {
            throw new IllegalArgumentException("Invalid ElasticSearch Index name: " + indexName);
        }
        this.elasticSearchClient = client;
        this.indexName = indexName;
        this.staticTableDefinitions = tableDefinitions == null || tableDefinitions.length == 0 ? Collections.emptyList() : Arrays.asList(tableDefinitions);
        this.dynamicTableDefinitions.addAll(Arrays.asList(this.detectSchema()));
    }

    public ElasticSearchRestDataContext(JestClient client, String indexName) {
        this(client, indexName, new SimpleTableDef[0]);
    }

    private SimpleTableDef[] detectSchema() {
        JestResult jestResult;
        logger.info("Detecting schema for index '{}'", (Object)this.indexName);
        try {
            GetMapping getMapping = ((GetMapping.Builder)new GetMapping.Builder().addIndex(this.indexName)).build();
            jestResult = this.elasticSearchClient.execute((Action)getMapping);
        }
        catch (Exception e) {
            logger.error("Failed to retrieve mappings", (Throwable)e);
            throw new MetaModelException("Failed to execute request for index information needed to detect schema", e);
        }
        if (!jestResult.isSucceeded()) {
            logger.error("Failed to retrieve mappings; {}", (Object)jestResult.getErrorMessage());
            throw new MetaModelException("Failed to retrieve mappings; " + jestResult.getErrorMessage());
        }
        ArrayList<SimpleTableDef> result = new ArrayList<SimpleTableDef>();
        Set mappings = jestResult.getJsonObject().getAsJsonObject(this.indexName).getAsJsonObject("mappings").entrySet();
        if (mappings.size() == 0) {
            logger.warn("No metadata returned for index name '{}' - no tables will be detected.");
        } else {
            for (Map.Entry entry : mappings) {
                String documentType = (String)entry.getKey();
                try {
                    SimpleTableDef table = ElasticSearchRestDataContext.detectTable(((JsonElement)entry.getValue()).getAsJsonObject().get("properties").getAsJsonObject(), documentType);
                    result.add(table);
                }
                catch (Exception e) {
                    logger.error("Unexpected error during detectTable for document type '{}'", (Object)documentType, (Object)e);
                }
            }
        }
        SimpleTableDef[] tableDefArray = result.toArray(new SimpleTableDef[result.size()]);
        Arrays.sort(tableDefArray, new Comparator<SimpleTableDef>(){

            @Override
            public int compare(SimpleTableDef o1, SimpleTableDef o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return tableDefArray;
    }

    private static SimpleTableDef detectTable(JsonObject metadataProperties, String documentType) {
        ElasticSearchMetaData metaData = JestElasticSearchMetaDataParser.parse(metadataProperties);
        return new SimpleTableDef(documentType, metaData.getColumnNames(), metaData.getColumnTypes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Schema getMainSchema() throws MetaModelException {
        MutableSchema theSchema = new MutableSchema(this.getMainSchemaName());
        for (SimpleTableDef tableDef : this.staticTableDefinitions) {
            this.addTable(theSchema, tableDef);
        }
        SimpleTableDef[] tables = this.detectSchema();
        ElasticSearchRestDataContext elasticSearchRestDataContext = this;
        synchronized (elasticSearchRestDataContext) {
            this.dynamicTableDefinitions.clear();
            this.dynamicTableDefinitions.addAll(Arrays.asList(tables));
            for (SimpleTableDef tableDef : this.dynamicTableDefinitions) {
                List<String> tableNames = Arrays.asList(theSchema.getTableNames());
                if (tableNames.contains(tableDef.getName())) continue;
                this.addTable(theSchema, tableDef);
            }
        }
        return theSchema;
    }

    private void addTable(MutableSchema theSchema, SimpleTableDef tableDef) {
        MutableTable table = tableDef.toTable().setSchema((Schema)theSchema);
        Column idColumn = table.getColumnByName(FIELD_ID);
        if (idColumn != null && idColumn instanceof MutableColumn) {
            MutableColumn mutableColumn = (MutableColumn)idColumn;
            mutableColumn.setPrimaryKey(true);
        }
        theSchema.addTable(table);
    }

    protected String getMainSchemaName() throws MetaModelException {
        return this.indexName;
    }

    protected DataSet materializeMainSchemaTable(Table table, List<SelectItem> selectItems, List<FilterItem> whereItems, int firstRow, int maxRows) {
        QueryBuilder queryBuilder = ElasticSearchUtils.createQueryBuilderForSimpleWhere(whereItems, (LogicalOperator)LogicalOperator.AND);
        if (queryBuilder != null) {
            SearchSourceBuilder searchSourceBuilder = this.createSearchRequest(firstRow, maxRows, queryBuilder);
            SearchResult result = this.executeSearch(table, searchSourceBuilder, this.scrollNeeded(maxRows));
            return new JestElasticSearchDataSet(this.elasticSearchClient, (JestResult)result, selectItems);
        }
        return super.materializeMainSchemaTable(table, selectItems, whereItems, firstRow, maxRows);
    }

    private boolean scrollNeeded(int maxRows) {
        return !this.limitMaxRowsIsSet(maxRows) || maxRows > 400;
    }

    private SearchResult executeSearch(Table table, SearchSourceBuilder searchSourceBuilder, boolean scroll) {
        SearchResult result;
        Search.Builder builder = (Search.Builder)((Search.Builder)new Search.Builder(searchSourceBuilder.toString()).addIndex(this.getIndexName())).addType(table.getName());
        if (scroll) {
            builder.setParameter("scroll", (Object)TIMEOUT_SCROLL);
        }
        Search search = builder.build();
        try {
            result = (SearchResult)this.elasticSearchClient.execute((Action)search);
        }
        catch (Exception e) {
            logger.warn("Could not execute ElasticSearch query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch query", e);
        }
        return result;
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        SearchResult searchResult = this.executeSearch(table, this.createSearchRequest(1, maxRows, null), this.scrollNeeded(maxRows));
        return new JestElasticSearchDataSet(this.elasticSearchClient, (JestResult)searchResult, columns);
    }

    private SearchSourceBuilder createSearchRequest(int firstRow, int maxRows, QueryBuilder queryBuilder) {
        SearchSourceBuilder searchRequest = new SearchSourceBuilder();
        if (firstRow > 1) {
            int zeroBasedFrom = firstRow - 1;
            searchRequest.from(zeroBasedFrom);
        }
        if (this.limitMaxRowsIsSet(maxRows)) {
            searchRequest.size(maxRows);
        } else {
            searchRequest.size(Integer.MAX_VALUE);
        }
        if (queryBuilder != null) {
            searchRequest.query(queryBuilder);
        }
        return searchRequest;
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        if (keyValue == null) {
            return null;
        }
        String documentType = table.getName();
        String id = keyValue.toString();
        Get get = ((Get.Builder)new Get.Builder(this.indexName, id).type(documentType)).build();
        Object getResult = JestClientExecutor.execute(this.elasticSearchClient, get);
        SimpleDataSetHeader header = new SimpleDataSetHeader(selectItems);
        return JestElasticSearchUtils.createRow(getResult.getJsonObject().get("_source").getAsJsonObject(), id, (DataSetHeader)header);
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        CountResult countResult;
        if (!whereItems.isEmpty()) {
            return null;
        }
        String documentType = table.getName();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"_type", (String)documentType));
        Count count = ((Count.Builder)new Count.Builder().addIndex(this.indexName)).query(sourceBuilder.toString()).build();
        try {
            countResult = (CountResult)this.elasticSearchClient.execute((Action)count);
        }
        catch (Exception e) {
            logger.warn("Could not execute ElasticSearch get query", (Throwable)e);
            throw new MetaModelException("Could not execute ElasticSearch get query", e);
        }
        return countResult.getCount();
    }

    private boolean limitMaxRowsIsSet(int maxRows) {
        return maxRows != -1;
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        boolean isBatch = update instanceof BatchUpdateScript;
        JestElasticSearchUpdateCallback callback = new JestElasticSearchUpdateCallback(this, isBatch);
        update.run((UpdateCallback)callback);
        callback.onExecuteUpdateFinished();
        return callback.getUpdateSummary();
    }

    public JestClient getElasticSearchClient() {
        return this.elasticSearchClient;
    }

    public String getIndexName() {
        return this.indexName;
    }
}

