/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.drop.AbstractTableDropBuilder;
import org.apache.metamodel.dynamodb.DynamoDbDataContext;
import org.apache.metamodel.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DynamoDbTableDropBuilder
extends AbstractTableDropBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDbTableDropBuilder.class);
    private final DynamoDbDataContext _dataContext;

    public DynamoDbTableDropBuilder(Table table, DynamoDbDataContext dataContext) {
        super(table);
        this._dataContext = dataContext;
    }

    public void execute() throws MetaModelException {
        String tableName = this.getTable().getName();
        DeleteTableResult result = this._dataContext.getDynamoDb().deleteTable(tableName);
        logger.debug("Dropped table {} in request ID: {}", (Object)tableName, (Object)result.getSdkResponseMetadata().getRequestId());
    }
}

