/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.util.HashMap;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.dynamodb.DynamoDbUpdateCallback;
import org.apache.metamodel.dynamodb.DynamoDbUtils;
import org.apache.metamodel.insert.AbstractRowInsertionBuilder;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.Table;

final class DynamoDbRowInsertionBuilder
extends AbstractRowInsertionBuilder<DynamoDbUpdateCallback> {
    public DynamoDbRowInsertionBuilder(DynamoDbUpdateCallback updateCallback, Table table) {
        super((UpdateCallback)updateCallback, table);
    }

    public void execute() throws MetaModelException {
        HashMap<String, AttributeValue> itemValues = new HashMap<String, AttributeValue>();
        Column[] columns = this.getColumns();
        Object[] values = this.getValues();
        for (int i = 0; i < columns.length; ++i) {
            Column column = columns[i];
            Object value = values[i];
            if (column.isPrimaryKey() && value == null) {
                throw new IllegalArgumentException("Value for '" + column.getName() + "' cannot be null");
            }
            AttributeValue attributeValue = DynamoDbUtils.toAttributeValue(value);
            itemValues.put(column.getName(), attributeValue);
        }
        AmazonDynamoDB dynamoDb = ((DynamoDbUpdateCallback)this.getUpdateCallback()).getDataContext().getDynamoDb();
        dynamoDb.putItem(this.getTable().getName(), itemValues);
    }
}

