/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndexDescription;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.QueryPostprocessDataContext;
import org.apache.metamodel.UpdateCallback;
import org.apache.metamodel.UpdateScript;
import org.apache.metamodel.UpdateSummary;
import org.apache.metamodel.UpdateableDataContext;
import org.apache.metamodel.data.DataSet;
import org.apache.metamodel.data.DataSetHeader;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.data.SimpleDataSetHeader;
import org.apache.metamodel.dynamodb.DynamoDbDataSet;
import org.apache.metamodel.dynamodb.DynamoDbUpdateCallback;
import org.apache.metamodel.dynamodb.DynamoDbUtils;
import org.apache.metamodel.query.FilterItem;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.schema.ColumnType;
import org.apache.metamodel.schema.MutableColumn;
import org.apache.metamodel.schema.MutableSchema;
import org.apache.metamodel.schema.MutableTable;
import org.apache.metamodel.schema.Schema;
import org.apache.metamodel.schema.Table;
import org.apache.metamodel.util.SimpleTableDef;

public class DynamoDbDataContext
extends QueryPostprocessDataContext
implements UpdateableDataContext,
Closeable {
    public static final String SYSTEM_PROPERTY_THROUGHPUT_READ_CAPACITY = "metamodel.dynamodb.throughput.capacity.read";
    public static final String SYSTEM_PROPERTY_THROUGHPUT_WRITE_CAPACITY = "metamodel.dynamodb.throughput.capacity.write";
    public static final String SCHEMA_NAME = "public";
    private final AmazonDynamoDB _dynamoDb;
    private final boolean _shutdownOnClose;
    private final SimpleTableDef[] _tableDefs;

    public DynamoDbDataContext() {
        this(AmazonDynamoDBClientBuilder.defaultClient(), null, true);
    }

    public DynamoDbDataContext(SimpleTableDef[] tableDefs) {
        this(AmazonDynamoDBClientBuilder.defaultClient(), tableDefs, true);
    }

    public DynamoDbDataContext(AmazonDynamoDB client) {
        this(client, null, false);
    }

    public DynamoDbDataContext(AmazonDynamoDB client, SimpleTableDef[] tableDefs) {
        this(client, tableDefs, false);
    }

    private DynamoDbDataContext(AmazonDynamoDB client, SimpleTableDef[] tableDefs, boolean shutdownOnClose) {
        this._dynamoDb = client;
        this._tableDefs = tableDefs == null ? new SimpleTableDef[]{} : tableDefs;
        this._shutdownOnClose = shutdownOnClose;
    }

    public AmazonDynamoDB getDynamoDb() {
        return this._dynamoDb;
    }

    @Override
    public void close() {
        if (this._shutdownOnClose) {
            this._dynamoDb.shutdown();
        }
    }

    protected Schema getMainSchema() throws MetaModelException {
        HashMap<String, SimpleTableDef> tableDefs = new HashMap<String, SimpleTableDef>();
        for (SimpleTableDef tableDef : this._tableDefs) {
            tableDefs.put(tableDef.getName(), tableDef);
        }
        MutableSchema schema = new MutableSchema(this.getMainSchemaName());
        ListTablesResult tables = this._dynamoDb.listTables();
        List tableNames = tables.getTableNames();
        for (String tableName : tableNames) {
            List localSecondaryIndexes;
            MutableTable table = new MutableTable(tableName, (Schema)schema);
            schema.addTable(table);
            DescribeTableResult descripeTableResult = this._dynamoDb.describeTable(tableName);
            TableDescription tableDescription = descripeTableResult.getTable();
            this.addColumnFromKeySchema("Primary index", tableDescription.getKeySchema(), table, true);
            List globalSecondaryIndexes = tableDescription.getGlobalSecondaryIndexes();
            if (globalSecondaryIndexes != null) {
                for (GlobalSecondaryIndexDescription globalSecondaryIndex : globalSecondaryIndexes) {
                    this.addColumnFromKeySchema(globalSecondaryIndex.getIndexName(), globalSecondaryIndex.getKeySchema(), table, false);
                }
            }
            if ((localSecondaryIndexes = tableDescription.getLocalSecondaryIndexes()) != null) {
                GlobalSecondaryIndexDescription globalSecondaryIndex;
                globalSecondaryIndex = localSecondaryIndexes.iterator();
                while (globalSecondaryIndex.hasNext()) {
                    LocalSecondaryIndexDescription localSecondaryIndex = (LocalSecondaryIndexDescription)globalSecondaryIndex.next();
                    this.addColumnFromKeySchema(localSecondaryIndex.getIndexName(), localSecondaryIndex.getKeySchema(), table, false);
                }
            }
            List attributeDefinitions = tableDescription.getAttributeDefinitions();
            for (AttributeDefinition attributeDefinition : attributeDefinitions) {
                String attributeName = attributeDefinition.getAttributeName();
                MutableColumn column = (MutableColumn)table.getColumnByName(attributeName);
                if (column == null) {
                    column = new MutableColumn(attributeName, (Table)table);
                    table.addColumn((Column)column);
                }
                String attributeType = attributeDefinition.getAttributeType();
                column.setType(DynamoDbUtils.toColumnType(attributeName, attributeType));
                column.setIndexed(true);
                column.setNativeType(attributeType);
            }
            SimpleTableDef tableDef = (SimpleTableDef)tableDefs.get(tableName);
            if (tableDef != null) {
                String[] columnNames = tableDef.getColumnNames();
                ColumnType[] columnTypes = tableDef.getColumnTypes();
                for (int i = 0; i < columnNames.length; ++i) {
                    String columnName = columnNames[i];
                    ColumnType columnType = columnTypes[i];
                    MutableColumn column = (MutableColumn)table.getColumnByName(columnName);
                    if (column == null) {
                        column = new MutableColumn(columnName, (Table)table);
                        table.addColumn((Column)column);
                    }
                    if (column.getType() != null || columnType == null) continue;
                    column.setType(columnType);
                }
            }
            if (globalSecondaryIndexes != null) {
                for (GlobalSecondaryIndexDescription globalSecondaryIndex : globalSecondaryIndexes) {
                    List nonKeyAttributes = globalSecondaryIndex.getProjection().getNonKeyAttributes();
                    for (String attributeName : nonKeyAttributes) {
                        this.addColumnFromNonKeyAttribute(globalSecondaryIndex.getIndexName(), table, attributeName);
                    }
                }
            }
            if (localSecondaryIndexes == null) continue;
            for (LocalSecondaryIndexDescription localSecondaryIndex : localSecondaryIndexes) {
                List nonKeyAttributes = localSecondaryIndex.getProjection().getNonKeyAttributes();
                for (String attributeName : nonKeyAttributes) {
                    this.addColumnFromNonKeyAttribute(localSecondaryIndex.getIndexName(), table, attributeName);
                }
            }
        }
        return schema;
    }

    private void addColumnFromNonKeyAttribute(String indexName, MutableTable table, String attributeName) {
        MutableColumn column = (MutableColumn)table.getColumnByName(attributeName);
        if (column == null) {
            column = new MutableColumn(attributeName, (Table)table);
            table.addColumn((Column)column);
        }
        DynamoDbDataContext.appendRemarks(column, indexName + " non-key attribute");
    }

    private void addColumnFromKeySchema(String indexName, List<KeySchemaElement> keySchema, MutableTable table, boolean primaryKey) {
        for (KeySchemaElement keySchemaElement : keySchema) {
            String attributeName = keySchemaElement.getAttributeName();
            if (table.getColumnByName(attributeName) != null) continue;
            String keyType = keySchemaElement.getKeyType();
            MutableColumn column = new MutableColumn(attributeName, (Table)table).setPrimaryKey(primaryKey);
            DynamoDbDataContext.appendRemarks(column, indexName + " member ('" + keyType + "' type)");
            table.addColumn((Column)column);
        }
    }

    private static void appendRemarks(MutableColumn column, String remarks) {
        String existingRemarks = column.getRemarks();
        if (existingRemarks == null) {
            column.setRemarks(remarks);
        } else {
            column.setRemarks(existingRemarks + ", " + remarks);
        }
    }

    protected String getMainSchemaName() throws MetaModelException {
        return SCHEMA_NAME;
    }

    protected Number executeCountQuery(Table table, List<FilterItem> whereItems, boolean functionApproximationAllowed) {
        if (!whereItems.isEmpty()) {
            return null;
        }
        return this._dynamoDb.describeTable(table.getName()).getTable().getItemCount();
    }

    protected DataSet materializeMainSchemaTable(Table table, Column[] columns, int maxRows) {
        ArrayList<String> attributeNames = new ArrayList<String>(columns.length);
        for (Column column : columns) {
            attributeNames.add(column.getName());
        }
        ScanRequest scanRequest = new ScanRequest(table.getName());
        scanRequest.setAttributesToGet(attributeNames);
        if (maxRows > 0) {
            scanRequest.setLimit(Integer.valueOf(maxRows));
        }
        ScanResult result = this._dynamoDb.scan(scanRequest);
        return new DynamoDbDataSet(columns, result);
    }

    protected Row executePrimaryKeyLookupQuery(Table table, List<SelectItem> selectItems, Column primaryKeyColumn, Object keyValue) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (SelectItem selectItem : selectItems) {
            attributeNames.add(selectItem.getColumn().getName());
        }
        GetItemRequest getItemRequest = new GetItemRequest(table.getName(), Collections.singletonMap(primaryKeyColumn.getName(), DynamoDbUtils.toAttributeValue(keyValue))).withAttributesToGet(attributeNames);
        GetItemResult item = this._dynamoDb.getItem(getItemRequest);
        Object[] values = new Object[selectItems.size()];
        for (int i = 0; i < values.length; ++i) {
            AttributeValue attributeValue = (AttributeValue)item.getItem().get(attributeNames.get(i));
            values[i] = DynamoDbUtils.toValue(attributeValue);
        }
        return new DefaultRow((DataSetHeader)new SimpleDataSetHeader(selectItems), values);
    }

    public UpdateSummary executeUpdate(UpdateScript update) {
        DynamoDbUpdateCallback callback = new DynamoDbUpdateCallback(this);
        try {
            update.run((UpdateCallback)callback);
        }
        finally {
            if (callback.isInterrupted()) {
                Thread.currentThread().interrupt();
            }
        }
        return callback.getUpdateSummary();
    }
}

