/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import org.apache.metamodel.schema.ColumnType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DynamoDbUtils {
    private static final Logger logger = LoggerFactory.getLogger(DynamoDbUtils.class);

    private DynamoDbUtils() {
    }

    public static AttributeValue toAttributeValue(Object value) {
        if (value instanceof AttributeValue) {
            return (AttributeValue)value;
        }
        AttributeValue attributeValue = new AttributeValue();
        if (value == null) {
            attributeValue.setNULL(Boolean.valueOf(true));
        } else if (value instanceof Number) {
            attributeValue.setN(value.toString());
        } else if (value instanceof Boolean) {
            attributeValue.setBOOL((Boolean)value);
        } else if (value instanceof String) {
            attributeValue.setS(value.toString());
        } else {
            throw new UnsupportedOperationException("Unsupported value type: " + value);
        }
        return attributeValue;
    }

    public static ScalarAttributeType toAttributeType(ColumnType type) {
        if (type == null) {
            return ScalarAttributeType.S;
        }
        if (type.isBinary()) {
            return ScalarAttributeType.B;
        }
        if (type.isNumber()) {
            return ScalarAttributeType.S;
        }
        return ScalarAttributeType.S;
    }

    public static ColumnType toColumnType(String attributeName, String attributeType) {
        if (attributeType == null) {
            return null;
        }
        switch (attributeType) {
            case "S": {
                return ColumnType.STRING;
            }
            case "N": {
                return ColumnType.NUMBER;
            }
            case "B": {
                return ColumnType.BINARY;
            }
        }
        logger.warn("Unexpected attribute type '{}' for attribute: {}", (Object)attributeType, (Object)attributeName);
        return null;
    }

    public static Object toValue(AttributeValue a) {
        if (a == null || Boolean.TRUE == a.isNULL()) {
            return null;
        }
        return DynamoDbUtils.firstNonNull(a.getB(), a.getBOOL(), a.getBS(), a.getL(), a.getM(), a.getN(), a.getNS(), a.getS(), a.getSS());
    }

    private static Object firstNonNull(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }
}

