/*
 * Decompiled with CFR 0.152.
 */
package org.apache.metamodel.csv;

import com.opencsv.CSVReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.metamodel.MetaModelException;
import org.apache.metamodel.csv.InconsistentRowLengthException;
import org.apache.metamodel.data.AbstractDataSet;
import org.apache.metamodel.data.DefaultRow;
import org.apache.metamodel.data.Row;
import org.apache.metamodel.query.SelectItem;
import org.apache.metamodel.schema.Column;
import org.apache.metamodel.util.FileHelper;

final class CsvDataSet
extends AbstractDataSet {
    private final CSVReader _reader;
    private final boolean _failOnInconsistentRowLength;
    private final int _columnsInTable;
    private volatile int _rowNumber;
    private volatile Integer _rowsRemaining;
    private volatile Row _row;

    public CsvDataSet(CSVReader reader, List<Column> columns, Integer maxRows, int columnsInTable, boolean failOnInconsistentRowLength) {
        super(columns.stream().map(SelectItem::new).collect(Collectors.toList()));
        this._reader = reader;
        this._columnsInTable = columnsInTable;
        this._failOnInconsistentRowLength = failOnInconsistentRowLength;
        this._rowNumber = 0;
        this._rowsRemaining = maxRows;
    }

    public void close() {
        FileHelper.safeClose((Object[])new Object[]{this._reader});
        this._row = null;
        this._rowsRemaining = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public Row getRow() throws MetaModelException {
        return this._row;
    }

    public boolean next() {
        if (this._rowsRemaining != null && this._rowsRemaining > 0) {
            Integer n = this._rowsRemaining;
            Integer n2 = this._rowsRemaining = Integer.valueOf(this._rowsRemaining - 1);
            return this.nextInternal();
        }
        if (this._rowsRemaining == null) {
            return this.nextInternal();
        }
        return false;
    }

    private boolean nextInternal() {
        String[] csvValues;
        if (this._reader == null) {
            return false;
        }
        try {
            csvValues = this._reader.readNext();
        }
        catch (IOException e) {
            throw new IllegalStateException("Exception reading from file", e);
        }
        if (csvValues == null) {
            this.close();
            return false;
        }
        if (csvValues.length == 1 && "".equals(csvValues[0])) {
            return this.nextInternal();
        }
        int size = this.getHeader().size();
        Object[] rowValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            Column column = this.getHeader().getSelectItem(i).getColumn();
            int columnNumber = column.getColumnNumber();
            rowValues[i] = columnNumber < csvValues.length ? csvValues[columnNumber] : null;
        }
        this._row = new DefaultRow(this.getHeader(), rowValues);
        if (this._failOnInconsistentRowLength) {
            ++this._rowNumber;
            if (this._columnsInTable != csvValues.length) {
                throw new InconsistentRowLengthException(this._columnsInTable, this._row, csvValues, this._rowNumber);
            }
        }
        return true;
    }
}

