/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.checkout;

import java.io.File;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.SvnCommandUtils;
import org.apache.maven.scm.provider.svn.SvnTagBranchUtils;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.checkout.SvnCheckOutConsumer;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnCheckOutCommand
extends AbstractCheckOutCommand
implements SvnCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        SvnScmProviderRepository repository = (SvnScmProviderRepository)repo;
        String url = repository.getUrl();
        if (tag != null && StringUtils.isNotEmpty((String)tag.trim())) {
            url = SvnTagBranchUtils.resolveTagUrl((SvnScmProviderRepository)repository, (String)tag);
        }
        url = SvnCommandUtils.fixUrl((String)url, (String)repository.getUser());
        Commandline cl = SvnCheckOutCommand.createCommandLine(repository, fileSet.getBasedir(), null, url);
        SvnCheckOutConsumer consumer = new SvnCheckOutConsumer(this.getLogger(), fileSet.getBasedir().getParentFile());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckOutScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(cl.toString(), consumer.getCheckedOutFiles());
    }

    public static Commandline createCommandLine(SvnScmProviderRepository repository, File workingDirectory, String revision, String url) {
        Commandline cl = SvnCommandLineUtils.getBaseSvnCommandLine(workingDirectory.getParentFile(), repository);
        cl.createArgument().setValue("checkout");
        if (StringUtils.isNotEmpty((String)revision)) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(revision);
        }
        cl.createArgument().setValue(url);
        cl.createArgument().setValue(workingDirectory.getName());
        return cl;
    }
}

