/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command;

import java.io.File;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.provider.svn.util.SvnUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class SvnCommandLineUtils {
    public static void addFiles(Commandline cl, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            cl.createArgument().setValue(files[i].getPath().replace('\\', '/'));
        }
    }

    public static Commandline getBaseSvnCommandLine(File workingDirectory, SvnScmProviderRepository repository) {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        if (!StringUtils.isEmpty((String)System.getProperty("maven.scm.svn.config_directory"))) {
            cl.createArgument().setValue("--config-dir");
            cl.createArgument().setValue(System.getProperty("maven.scm.svn.config_directory"));
        } else if (!StringUtils.isEmpty((String)SvnUtil.getSettings().getConfigDirectory())) {
            cl.createArgument().setValue("--config-dir");
            cl.createArgument().setValue(SvnUtil.getSettings().getConfigDirectory());
        }
        if (repository != null && !StringUtils.isEmpty((String)repository.getUser())) {
            cl.createArgument().setValue("--username");
            cl.createArgument().setValue(repository.getUser());
        }
        if (repository != null && !StringUtils.isEmpty((String)repository.getPassword())) {
            cl.createArgument().setValue("--password");
            cl.createArgument().setValue(repository.getPassword());
        }
        cl.createArgument().setValue("--non-interactive");
        return cl;
    }

    public static int execute(Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        exitCode = SvnCommandLineUtils.checkIfCleanUpIsNeeded(exitCode, cl, consumer, stderr, logger);
        return exitCode;
    }

    public static int execute(Commandline cl, CommandLineUtils.StringStreamConsumer stdout, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        int exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        exitCode = SvnCommandLineUtils.checkIfCleanUpIsNeeded(exitCode, cl, (StreamConsumer)stdout, stderr, logger);
        return exitCode;
    }

    private static int checkIfCleanUpIsNeeded(int exitCode, Commandline cl, StreamConsumer consumer, CommandLineUtils.StringStreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        if (exitCode != 0 && stderr.getOutput() != null && stderr.getOutput().indexOf("'svn cleanup'") > 0 && stderr.getOutput().indexOf("'svn help cleanup'") > 0) {
            logger.info("Svn command failed due to some locks in working copy. We try to run a 'svn cleanup'.");
            if (SvnCommandLineUtils.executeCleanUp(cl.getWorkingDirectory(), consumer, (StreamConsumer)stderr, logger) == 0) {
                exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
            }
        }
        return exitCode;
    }

    public static int executeCleanUp(File workinDirectory, StreamConsumer stdout, StreamConsumer stderr) throws CommandLineException {
        return SvnCommandLineUtils.executeCleanUp(workinDirectory, stdout, stderr, null);
    }

    public static int executeCleanUp(File workinDirectory, StreamConsumer stdout, StreamConsumer stderr, ScmLogger logger) throws CommandLineException {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        cl.setWorkingDirectory(workinDirectory.getAbsolutePath());
        if (logger != null) {
            logger.info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            logger.info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        return CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
    }

    public static String cryptPassword(Commandline cl) {
        String clString = cl.toString();
        int pos = clString.indexOf("--password");
        if (pos > 0) {
            String beforePassword = clString.substring(0, pos + "--password ".length());
            String afterPassword = clString.substring(pos + "--password ".length());
            afterPassword = afterPassword.substring(afterPassword.indexOf(" "));
            clString = beforePassword + "*****" + afterPassword;
        }
        return clString;
    }
}

