/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.status;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.status.AbstractStatusCommand;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.status.CvsStatusConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsStatusCommand
extends AbstractStatusCommand
implements CvsCommand {
    protected StatusScmResult executeStatusCommand(ScmProviderRepository repo, ScmFileSet fileSet) throws ScmException {
        int exitCode;
        Commandline cl = this.createCommandLine(fileSet);
        CvsStatusConsumer consumer = new CvsStatusConsumer(this.getLogger(), fileSet.getBasedir());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new StatusScmResult("The cvs command failed.", stderr.getOutput(), false);
        }
        return new StatusScmResult(consumer.getChangedFiles());
    }

    public Commandline createCommandLine(ScmFileSet fileSet) throws ScmException {
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-n");
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("update");
        cl.createArgument().setValue("-d");
        return cl;
    }
}

