/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.checkout;

import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.checkout.CvsCheckOutConsumer;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsCheckOutCommand
extends AbstractCheckOutCommand
implements CvsCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        int exitCode;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getParentFile().getAbsolutePath());
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(repository.getCvsRoot());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("checkout");
        if (tag != null) {
            cl.createArgument().setValue("-r" + tag);
        }
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(fileSet.getBasedir().getName());
        cl.createArgument().setValue(repository.getModule());
        CvsCheckOutConsumer consumer = new CvsCheckOutConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().debug("Working directory: " + fileSet.getBasedir().getAbsolutePath());
        this.getLogger().debug("Command line: " + cl);
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new CheckOutScmResult("The cvs command failed.", stderr.getOutput(), false);
        }
        return new CheckOutScmResult(consumer.getCheckedOutFiles());
    }
}

