/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.checkin;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkin.AbstractCheckInCommand;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.checkin.CvsCheckInConsumer;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsCheckInCommand
extends AbstractCheckInCommand
implements CvsCommand {
    protected CheckInScmResult executeCheckInCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, String tag) throws ScmException {
        int exitCode;
        File messageFile;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        cl.createArgument().setValue("-f");
        try {
            messageFile = File.createTempFile("scm-commit-message", ".txt");
            FileUtils.fileWrite((String)messageFile.getAbsolutePath(), (String)message);
        }
        catch (IOException ex) {
            throw new ScmException("Error while making a temporary commit message file.");
        }
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(repository.getCvsRoot());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("commit");
        if (!StringUtils.isEmpty((String)tag)) {
            cl.createArgument().setValue("-r" + tag);
        }
        cl.createArgument().setValue("-R");
        cl.createArgument().setValue("-F");
        cl.createArgument().setValue(messageFile.getAbsolutePath());
        File[] files = fileSet.getFiles();
        for (int i = 0; i < files.length; ++i) {
            cl.createArgument().setValue(files[i].getPath().replace('\\', '/'));
        }
        CvsCheckInConsumer consumer = new CvsCheckInConsumer(repository.getPath());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        try {
            FileUtils.forceDelete((File)messageFile);
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (exitCode != 0) {
            return new CheckInScmResult("The cvs command failed.", stderr.getOutput(), false);
        }
        return new CheckInScmResult(consumer.getCheckedInFiles());
    }
}

