/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.changelog;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.maven.scm.command.changelog.ChangeLogEntry;
import org.apache.maven.scm.command.changelog.ChangeLogFile;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsChangeLogConsumer
implements StreamConsumer {
    private static final SimpleDateFormat ENTRY_KEY_TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    private Map entries = new TreeMap(Collections.reverseOrder());
    private static final int GET_FILE = 1;
    private static final int GET_DATE = 2;
    private static final int GET_COMMENT = 3;
    private static final int GET_REVISION = 4;
    private static final String START_FILE = "Working file: ";
    private static final String END_FILE = "=============================================================================";
    private static final String START_REVISION = "----------------------------";
    private static final String REVISION_TAG = "revision ";
    private static final String DATE_TAG = "date: ";
    private int status = 1;
    private ChangeLogEntry currentLogEntry = null;
    private ChangeLogFile currentFile = null;
    private Logger logger;

    public CvsChangeLogConsumer(Logger logger) {
        this.logger = logger;
    }

    public List getModifications() {
        return new ArrayList(this.entries.values());
    }

    public void consumeLine(String line) {
        try {
            switch (this.getStatus()) {
                case 1: {
                    this.processGetFile(line);
                    break;
                }
                case 4: {
                    this.processGetRevision(line);
                    break;
                }
                case 2: {
                    this.processGetDate(line);
                    break;
                }
                case 3: {
                    this.processGetComment(line);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + this.status);
                }
            }
        }
        catch (Throwable ex) {
            this.logger.warn("Exception in the cvs changelog consumer.", ex);
        }
    }

    private void addEntry(ChangeLogEntry entry, ChangeLogFile file) {
        if (entry.getAuthor() == null) {
            return;
        }
        String key = ENTRY_KEY_TIMESTAMP_FORMAT.format(entry.getDate()) + entry.getAuthor() + entry.getComment();
        if (!this.entries.containsKey(key)) {
            entry.addFile(file);
            this.entries.put(key, entry);
        } else {
            ChangeLogEntry existingEntry = (ChangeLogEntry)this.entries.get(key);
            existingEntry.addFile(file);
        }
    }

    private void processGetFile(String line) {
        if (line.startsWith(START_FILE)) {
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(line.substring(START_FILE.length(), line.length())));
            this.setStatus(4);
        }
    }

    private void processGetRevision(String line) {
        if (line.startsWith(REVISION_TAG)) {
            this.getCurrentFile().setRevision(line.substring(REVISION_TAG.length()));
            this.setStatus(2);
        } else if (line.startsWith(END_FILE)) {
            this.setStatus(1);
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
        }
    }

    private void processGetDate(String line) {
        if (line.startsWith(DATE_TAG)) {
            StringTokenizer tokenizer = new StringTokenizer(line, " ;");
            tokenizer.nextToken();
            String date = tokenizer.nextToken();
            String time = tokenizer.nextToken();
            this.getCurrentLogEntry().setDate(date + " " + time);
            tokenizer.nextToken();
            String author = tokenizer.nextToken();
            this.getCurrentLogEntry().setAuthor(author);
            this.setStatus(3);
        }
    }

    private void processGetComment(String line) {
        if (line.startsWith(START_REVISION)) {
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setCurrentLogEntry(new ChangeLogEntry());
            this.setCurrentFile(new ChangeLogFile(this.getCurrentFile().getName()));
            this.setStatus(4);
        } else if (line.startsWith(END_FILE)) {
            this.addEntry(this.getCurrentLogEntry(), this.getCurrentFile());
            this.setStatus(1);
        } else {
            this.getCurrentLogEntry().setComment(this.getCurrentLogEntry().getComment() + line + "\n");
        }
    }

    private ChangeLogFile getCurrentFile() {
        return this.currentFile;
    }

    private void setCurrentFile(ChangeLogFile currentFile) {
        this.currentFile = currentFile;
    }

    private ChangeLogEntry getCurrentLogEntry() {
        return this.currentLogEntry;
    }

    private void setCurrentLogEntry(ChangeLogEntry currentLogEntry) {
        this.currentLogEntry = currentLogEntry;
    }

    private int getStatus() {
        return this.status;
    }

    private void setStatus(int status) {
        this.status = status;
    }
}

