/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.add;

import java.io.File;
import java.util.ArrayList;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class CvsAddCommand
extends AbstractAddCommand
implements CvsCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repo, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        int exitCode;
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = new Commandline();
        cl.setExecutable("cvs");
        cl.setWorkingDirectory(fileSet.getBasedir().getAbsolutePath());
        cl.createArgument().setValue("-f");
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(repository.getCvsRoot());
        cl.createArgument().setValue("-q");
        cl.createArgument().setValue("add");
        if (binary) {
            cl.createArgument().setValue("-kb");
        }
        if (message != null && message.length() > 0) {
            cl.createArgument().setValue("-m");
            cl.createArgument().setValue("\"" + message + "\"");
        }
        File[] files = fileSet.getFiles();
        ArrayList<ScmFile> addedFiles = new ArrayList<ScmFile>();
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getPath().replace('\\', '/');
            cl.createArgument().setValue(path);
            addedFiles.add(new ScmFile(path, ScmFileStatus.ADDED));
        }
        CommandLineUtils.StringStreamConsumer consumer = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)consumer, (StreamConsumer)stderr);
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new AddScmResult("The cvs command failed.", stderr.getOutput(), false);
        }
        return new AddScmResult(addedFiles);
    }
}

