/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.codehaus.plexus.util.StringUtils;

public class CvsScmProvider
extends AbstractScmProvider {
    private static final String TRANSPORT_LOCAL = "local";
    private static final String TRANSPORT_PSERVER = "pserver";
    private static final String TRANSPORT_LSERVER = "lserver";
    private static final String TRANSPORT_EXT = "ext";
    private Map commands;

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        ScmUrlParserResult result = this.parseScmUrl(scmSpecificUrl, delimiter);
        return result.messages;
    }

    protected Map getCommands() {
        return this.commands;
    }

    public String getScmType() {
        return "cvs";
    }

    private ScmUrlParserResult parseScmUrl(String scmSpecificUrl, char delimiter) {
        String module;
        String path;
        String cvsroot;
        ScmUrlParserResult result = new ScmUrlParserResult();
        String[] tokens = StringUtils.split((String)scmSpecificUrl, (String)Character.toString(delimiter));
        if (tokens.length < 3) {
            result.messages.add("The connection string contains to few tokens.");
            return result;
        }
        String transport = tokens[0];
        if (transport.equalsIgnoreCase(TRANSPORT_LOCAL)) {
            cvsroot = tokens[1];
        } else if (transport.equalsIgnoreCase(TRANSPORT_PSERVER) || transport.equalsIgnoreCase(TRANSPORT_LSERVER) || transport.equalsIgnoreCase(TRANSPORT_EXT)) {
            if (tokens.length != 4) {
                result.messages.add("The connection string contains to few tokens.");
                return result;
            }
            cvsroot = transport.equalsIgnoreCase(TRANSPORT_LSERVER) ? tokens[1] + ":" + tokens[2] : ":" + transport + ":" + tokens[1] + ":" + tokens[2];
        } else {
            result.messages.add("Unknown transport: " + transport);
            return result;
        }
        String user = null;
        String host = null;
        if (!transport.equalsIgnoreCase(TRANSPORT_LOCAL)) {
            String userhost = tokens[1];
            int index = userhost.indexOf("@");
            if (index == -1) {
                result.messages.add("The userhost part must be on the form: <username>@<hostname>.");
                return result;
            }
            user = userhost.substring(0, index);
            host = userhost.substring(index + 1);
        }
        if (transport.equals(TRANSPORT_LOCAL)) {
            path = tokens[1];
            module = tokens[2];
        } else {
            path = tokens[2];
            module = tokens[3];
        }
        result.repository = new CvsScmProviderRepository(cvsroot, transport, user, host, path, module);
        return result;
    }

    private static class ScmUrlParserResult {
        List messages = new ArrayList();
        ScmProviderRepository repository;

        private ScmUrlParserResult() {
        }
    }
}

