/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.NoSuchCommandScmException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.log.ScmLogDispatcher;
import org.apache.maven.scm.log.ScmLogger;
import org.apache.maven.scm.login.LoginScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public abstract class AbstractScmProvider
implements ScmProvider {
    private ScmLogDispatcher logDispatcher = new ScmLogDispatcher();

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        ArrayList<String> messages = new ArrayList<String>();
        try {
            this.makeProviderScmRepository(scmSpecificUrl, delimiter);
        }
        catch (ScmRepositoryException e) {
            messages.add(e.getMessage());
        }
        return messages;
    }

    public AddScmResult add(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.MESSAGE, "");
        parameters.setString(CommandParameter.BINARY, "false");
        return this.add(repository, fileSet, parameters);
    }

    protected AddScmResult add(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("add");
    }

    public ChangeLogScmResult changeLog(ScmRepository repository, ScmFileSet fileSet, Date startDate, Date endDate, int numDays, String branch) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setDate(CommandParameter.START_DATE, startDate);
        parameters.setDate(CommandParameter.END_DATE, endDate);
        parameters.setString(CommandParameter.BRANCH, branch);
        return this.changelog(repository, fileSet, parameters);
    }

    protected ChangeLogScmResult changelog(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("changelog");
    }

    public CheckInScmResult checkIn(ScmRepository repository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        parameters.setString(CommandParameter.MESSAGE, message);
        return this.checkin(repository, fileSet, parameters);
    }

    protected CheckInScmResult checkin(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("checkin");
    }

    public CheckOutScmResult checkOut(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        return this.checkout(repository, fileSet, parameters);
    }

    protected CheckOutScmResult checkout(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("checkout");
    }

    public DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, String startRevision, String endRevision) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.START_REVISION, startRevision);
        parameters.setString(CommandParameter.END_REVISION, endRevision);
        return this.diff(repository, fileSet, parameters);
    }

    protected DiffScmResult diff(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("diff");
    }

    private void login(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        LoginScmResult result = this.login(repository, fileSet, new CommandParameters());
        if (!result.isSuccess()) {
            throw new ScmException("Can't login.\n" + result.getCommandOutput());
        }
    }

    protected LoginScmResult login(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        LoginScmResult result = new LoginScmResult(null, null, null, true);
        return result;
    }

    public RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.MESSAGE, message == null ? "" : message);
        return this.remove(repository, fileSet, parameters);
    }

    protected RemoveScmResult remove(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("remove");
    }

    public StatusScmResult status(ScmRepository repository, ScmFileSet fileSet) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        return this.status(repository, fileSet, parameters);
    }

    protected StatusScmResult status(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("status");
    }

    public TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        return this.tag(repository, fileSet, parameters);
    }

    protected TagScmResult tag(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("tag");
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        return this.update(repository, fileSet, parameters);
    }

    public UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, String tag, Date lastUpdate) throws ScmException {
        this.login(repository, fileSet);
        CommandParameters parameters = new CommandParameters();
        parameters.setString(CommandParameter.TAG, tag);
        if (lastUpdate != null) {
            parameters.setDate(CommandParameter.START_DATE, lastUpdate);
        }
        return this.update(repository, fileSet, parameters);
    }

    protected UpdateScmResult update(ScmRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        throw new NoSuchCommandScmException("update");
    }

    public void addListener(ScmLogger logger) {
        this.logDispatcher.addListener(logger);
    }

    public ScmLogger getLogger() {
        return this.logDispatcher;
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        throw new UnknownRepositoryStructure();
    }

    public abstract /* synthetic */ ScmProviderRepository makeProviderScmRepository(String var1, char var2) throws ScmRepositoryException;

    public abstract /* synthetic */ String getScmType();
}

