/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ChangeFile;

public class ChangeSet {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat TIME_FORMAT = new SimpleDateFormat("HH:mm:ss");
    private static final SimpleDateFormat TIMESTAMP_FORMAT_1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private static final SimpleDateFormat TIMESTAMP_FORMAT_2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private Date date;
    private String author;
    private String comment = "";
    private List files;

    public ChangeSet(String date, String comment, String author, List files) {
        this.setDate(date);
        this.setAuthor(author);
        this.setComment(comment);
        this.files = files;
    }

    public ChangeSet() {
    }

    public List getFiles() {
        return this.files;
    }

    public void setFiles(List files) {
        this.files = files;
    }

    public void addFile(ChangeFile file) {
        if (this.files == null) {
            this.files = new ArrayList();
        }
        this.files.add(file);
    }

    public boolean containsFilename(String filename) {
        if (this.files != null) {
            Iterator i = this.files.iterator();
            while (i.hasNext()) {
                ChangeFile file = (ChangeFile)i.next();
                if (!file.getName().equals(filename)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Date getDate() {
        return (Date)this.date.clone();
    }

    public void setDate(Date date) {
        this.date = new Date(date.getTime());
    }

    public void setDate(String date) {
        try {
            this.date = TIMESTAMP_FORMAT_1.parse(date);
        }
        catch (ParseException e) {
            try {
                this.date = TIMESTAMP_FORMAT_2.parse(date);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("Unable to parse CVS date: " + date);
            }
        }
    }

    public synchronized String getDateFormatted() {
        return DATE_FORMAT.format(this.getDate());
    }

    public synchronized String getTimeFormatted() {
        return TIME_FORMAT.format(this.getDate());
    }

    public String toString() {
        String result = this.author + "\n" + this.date + "\n";
        if (this.files != null) {
            Iterator i = this.files.iterator();
            while (i.hasNext()) {
                ChangeFile file = (ChangeFile)i.next();
                result = result + file + "\n";
            }
        }
        result = result + this.comment;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChangeSet) {
            ChangeSet changeSet = (ChangeSet)obj;
            if (this.toString().equals(changeSet.toString())) {
                return true;
            }
        }
        return false;
    }
}

