/*
 * Decompiled with CFR 0.152.
 */
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Tag;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class Options
implements Cloneable {
    private Vector hidePatterns;
    PrintWriter w;
    boolean showQualified = false;
    boolean showAttributes = false;
    boolean showOperations = false;
    boolean showConstructors = false;
    boolean showVisibility = false;
    boolean horizontal;
    boolean showType = false;
    String edgeFontName = "Helvetica";
    String edgeFontColor = "black";
    String edgeColor = "black";
    double edgeFontSize = 10.0;
    String nodeFontName = "Helvetica";
    String nodeFontAbstractName = "Helvetica-Oblique";
    String nodeFontColor = "black";
    double nodeFontSize = 10.0;
    String nodeFillColor = null;
    String bgColor = null;
    String outputFileName = "graph.dot";
    String outputEncoding = "ISO-8859-1";
    String apiDocMapFileName = null;
    String apiDocRoot = null;
    boolean useGuillemot = true;
    char guilOpen = (char)171;
    char guilClose = (char)187;

    Options() {
        this.hidePatterns = new Vector();
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    public void setAll() {
        this.showAttributes = true;
        this.showOperations = true;
        this.showConstructors = true;
        this.showVisibility = true;
        this.showType = true;
    }

    private void setOption(String[] stringArray) {
        if (stringArray[0].equals("-qualify")) {
            this.showQualified = true;
        } else if (stringArray[0].equals("-horizontal")) {
            this.horizontal = true;
        } else if (stringArray[0].equals("-attributes")) {
            this.showAttributes = true;
        } else if (stringArray[0].equals("-operations")) {
            this.showOperations = true;
        } else if (stringArray[0].equals("-constructors")) {
            this.showConstructors = true;
        } else if (stringArray[0].equals("-visibility")) {
            this.showVisibility = true;
        } else if (stringArray[0].equals("-types")) {
            this.showType = true;
        } else if (stringArray[0].equals("-all")) {
            this.setAll();
        } else if (stringArray[0].equals("-bgcolor")) {
            this.bgColor = stringArray[1];
        } else if (stringArray[0].equals("-edgecolor")) {
            this.edgeColor = stringArray[1];
        } else if (stringArray[0].equals("-edgefontcolor")) {
            this.edgeFontColor = stringArray[1];
        } else if (stringArray[0].equals("-edgefontname")) {
            this.edgeFontName = stringArray[1];
        } else if (stringArray[0].equals("-edgefontsize")) {
            this.edgeFontSize = Integer.parseInt(stringArray[1]);
        } else if (stringArray[0].equals("-nodefontcolor")) {
            this.nodeFontColor = stringArray[1];
        } else if (stringArray[0].equals("-nodefontname")) {
            this.nodeFontName = stringArray[1];
        } else if (stringArray[0].equals("-nodefontabstractname")) {
            this.nodeFontAbstractName = stringArray[1];
        } else if (stringArray[0].equals("-nodefontsize")) {
            this.nodeFontSize = Integer.parseInt(stringArray[1]);
        } else if (stringArray[0].equals("-nodefillcolor")) {
            this.nodeFillColor = stringArray[1];
        } else if (stringArray[0].equals("-output")) {
            this.outputFileName = stringArray[1];
        } else if (stringArray[0].equals("-outputencoding")) {
            this.outputEncoding = stringArray[1];
        } else if (stringArray[0].equals("-hide")) {
            try {
                this.hidePatterns.add(Pattern.compile(stringArray[1]));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                System.err.println("Skipping invalid pattern " + stringArray[1]);
            }
        } else if (stringArray[0].equals("-apidocroot")) {
            this.apiDocRoot = stringArray[1];
        } else if (stringArray[0].equals("-apidocmap")) {
            this.apiDocMapFileName = stringArray[1];
        } else if (stringArray[0].equals("-noguillemot")) {
            this.guilOpen = (char)40;
            this.guilClose = (char)41;
        }
    }

    public void setOptions(String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.setOption(stringArray[i]);
        }
    }

    public void setOptions(ClassDoc classDoc) {
        if (classDoc == null) {
            return;
        }
        Tag[] tagArray = classDoc.tags("opt");
        for (int i = 0; i < tagArray.length; ++i) {
            String[] stringArray = StringUtil.tokenize(tagArray[i].text());
            stringArray[0] = "-" + stringArray[0];
            this.setOption(stringArray);
        }
    }

    public void openFile() throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.outputFileName);
        this.w = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.outputEncoding)));
    }

    public boolean matchesHideExpression(String string) {
        for (int i = 0; i < this.hidePatterns.size(); ++i) {
            Pattern pattern = (Pattern)this.hidePatterns.get(i);
            Matcher matcher = pattern.matcher(string);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }
}

