package org.apache.maven.plugin.dependency;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-dependency-plugin.<br/> Call <pre>  mvn dependency:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Wed Jul 06 13:56:43 IST 2011
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-dependency-plugin:2.3", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Dependency Plugin", 0 );
        append( sb, "Provides utility goals to work with dependencies like copying, unpacking, analyzing, resolving and many more.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 21 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "analyze".equals( goal ) )
        {
            append( sb, "dependency:analyze", 0 );
            append( sb, "Analyzes the dependencies of this project and determines which are: used and declared; used and undeclared; unused and declared. This goal is intended to be used standalone, thus it always executes the test-compile phase - use the dependency:analyze-only goal instead when participating in the build lifecycle.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "analyzer (Default: default)", 2 );
                append( sb, "Project dependency analyzer to use (plexus component role-hint).", 3 );
                append( sb, "Expression: ${analyzer}", 3 );
                append( sb, "", 0 );

                append( sb, "failOnWarning (Default: false)", 2 );
                append( sb, "Whether to fail the build if a dependency warning is found.", 3 );
                append( sb, "Expression: ${failOnWarning}", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreNonCompile (Default: false)", 2 );
                append( sb, "Ignore Runtime,Provide,Test,System scopes for unused dependency analysis", 3 );
                append( sb, "Expression: ${ignoreNonCompile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputXML (Default: false)", 2 );
                append( sb, "Output the xml for the missing dependencies", 3 );
                append( sb, "Expression: ${outputXML}", 3 );
                append( sb, "", 0 );

                append( sb, "scriptableFlag (Default: $$$%%%)", 2 );
                append( sb, "Flag to use for scriptable output", 3 );
                append( sb, "Expression: ${scriptableFlag}", 3 );
                append( sb, "", 0 );

                append( sb, "scriptableOutput (Default: false)", 2 );
                append( sb, "Output scriptable values", 3 );
                append( sb, "Expression: ${scriptableOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Output used dependencies", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "analyze-dep-mgt".equals( goal ) )
        {
            append( sb, "dependency:analyze-dep-mgt", 0 );
            append( sb, "This mojo looks at the dependencies after final resolution and looks for mismatches in your dependencyManagement section. In versions of maven prior to 2.0.6, it was possible to inherit versions that didn\'t match your dependencyManagement. See MNG-1577 for more info. This mojo is also useful for just detecting projects that override the dependencyManagement directly. Set ignoreDirect to false to detect these otherwise normal conditions.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "failBuild (Default: false)", 2 );
                append( sb, "Fail the build if a problem is detected.", 3 );
                append( sb, "Expression: ${mdep.analyze.failBuild}", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreDirect (Default: true)", 2 );
                append( sb, "Ignore Direct Dependency Overrides of dependencyManagement section.", 3 );
                append( sb, "Expression: ${mdep.analyze.ignore.direct}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "analyze-duplicate".equals( goal ) )
        {
            append( sb, "dependency:analyze-duplicate", 0 );
            append( sb, "Analyzes the <dependencies/> and <dependencyManagement/> tags in the pom.xml and determines the duplicate declared dependencies.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "analyze-only".equals( goal ) )
        {
            append( sb, "dependency:analyze-only", 0 );
            append( sb, "Analyzes the dependencies of this project and determines which are: used and declared; used and undeclared; unused and declared. This goal is intended to be used in the build lifecycle, thus it assumes that the test-compile phase has been executed - use the dependency:analyze goal instead when running standalone.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "analyzer (Default: default)", 2 );
                append( sb, "Project dependency analyzer to use (plexus component role-hint).", 3 );
                append( sb, "Expression: ${analyzer}", 3 );
                append( sb, "", 0 );

                append( sb, "failOnWarning (Default: false)", 2 );
                append( sb, "Whether to fail the build if a dependency warning is found.", 3 );
                append( sb, "Expression: ${failOnWarning}", 3 );
                append( sb, "", 0 );

                append( sb, "ignoreNonCompile (Default: false)", 2 );
                append( sb, "Ignore Runtime,Provide,Test,System scopes for unused dependency analysis", 3 );
                append( sb, "Expression: ${ignoreNonCompile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputXML (Default: false)", 2 );
                append( sb, "Output the xml for the missing dependencies", 3 );
                append( sb, "Expression: ${outputXML}", 3 );
                append( sb, "", 0 );

                append( sb, "scriptableFlag (Default: $$$%%%)", 2 );
                append( sb, "Flag to use for scriptable output", 3 );
                append( sb, "Expression: ${scriptableFlag}", 3 );
                append( sb, "", 0 );

                append( sb, "scriptableOutput (Default: false)", 2 );
                append( sb, "Output scriptable values", 3 );
                append( sb, "Expression: ${scriptableOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Output used dependencies", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "analyze-report".equals( goal ) )
        {
            append( sb, "dependency:analyze-report", 0 );
            append( sb, "Analyzes the dependencies of this project and produces a report that summarizes which are: used and declared; used and undeclared; unused and declared.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "ignoreNonCompile (Default: false)", 2 );
                append( sb, "Ignore Runtime,Provide,Test,System scopes for unused dependency analysis", 3 );
                append( sb, "Expression: ${ignoreNonCompile}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "build-classpath".equals( goal ) )
        {
            append( sb, "dependency:build-classpath", 0 );
            append( sb, "This goal will output a classpath string of dependencies from the local repository to a file or log.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "attach (Default: false)", 2 );
                append( sb, "Attach the classpath file to the main artifact so it can be installed and deployed.", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "cpFile", 2 );
                append( sb, "Deprecated. use outputFile instead", 3 );
                append( sb, "", 0 );
                append( sb, "The file to write the classpath string. If undefined, it just prints the classpath as [INFO]. This parameter is deprecated. Use outputFile instead.", 3 );
                append( sb, "Expression: ${mdep.cpFile}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "fileSeparator", 2 );
                append( sb, "Override the char used between the paths. This field is initialized to contain the first character of the value of the system property file.separator. On UNIX systems the value of this field is \'/\'; on Microsoft Windows systems it is \'\\\'. The default is File.separator", 3 );
                append( sb, "Expression: ${mdep.fileSeparator}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "localRepoProperty", 2 );
                append( sb, "Replace the absolute path to the local repo with this property. This field is ignored it prefix is declared. The value will be forced to \'${M2_REPO}\' if no value is provided AND the attach flag is true.", 3 );
                append( sb, "Expression: ${mdep.localRepoProperty}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "The file to write the classpath string. If undefined, it just prints the classpath as [INFO].", 3 );
                append( sb, "Expression: ${mdep.outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFilterFile (Default: false)", 2 );
                append( sb, "Write out the classpath in a format compatible with filtering (classpath=xxxxx)", 3 );
                append( sb, "Expression: ${mdep.outputFilterFile}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "pathSeparator", 2 );
                append( sb, "Override the char used between path folders. The system-dependent path-separator character. This field is initialized to contain the first character of the value of the system property path.separator. This character is used to separate filenames in a sequence of files given as a path list. On UNIX systems, this character is \':\'; on Microsoft Windows systems it is \';\'.", 3 );
                append( sb, "Expression: ${mdep.pathSeparator}", 3 );
                append( sb, "", 0 );

                append( sb, "prefix", 2 );
                append( sb, "The prefix to prepend on each dependent artifact. If undefined, the paths refer to the actual files store in the local repository (the stipVersion parameter does nothing then).", 3 );
                append( sb, "Expression: ${mdep.prefix}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "regenerateFile (Default: false)", 2 );
                append( sb, "If \'true\', it skips the up-to-date-check, and always regenerates the classpath file.", 3 );
                append( sb, "Expression: ${mdep.regenerateFile}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "stripVersion (Default: false)", 2 );
                append( sb, "Strip artifact version during copy (only works if prefix is set)", 3 );
                append( sb, "Expression: ${mdep.stripVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "copy".equals( goal ) )
        {
            append( sb, "dependency:copy", 0 );
            append( sb, "Goal that copies a list of artifacts from the repository to defined locations.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactItems", 2 );
                append( sb, "Collection of ArtifactItems to work on. (ArtifactItem contains groupId, artifactId, version, type, classifier, location, destFileName, markerFile and overwrite.) See Usage for details.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "localRepositoryDirectory", 2 );
                append( sb, "Path to override default local repository during plugin\'s execution. To remove all downloaded artifacts as part of the build, set this value to a location under your project\'s target directory", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/dependency)", 2 );
                append( sb, "Default location used for mojo unless overridden in ArtifactItem", 3 );
                append( sb, "Expression: ${outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite if newer", 3 );
                append( sb, "Expression: ${mdep.overIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${mdep.overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${mdep.overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the execution", 3 );
                append( sb, "Expression: ${mdep.skip}", 3 );
                append( sb, "", 0 );

                append( sb, "stripVersion (Default: false)", 2 );
                append( sb, "Strip artifact version during copy", 3 );
                append( sb, "Expression: ${mdep.stripVersion}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "copy-dependencies".equals( goal ) )
        {
            append( sb, "dependency:copy-dependencies", 0 );
            append( sb, "Goal that copies the project dependencies from the repository to a defined location.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "copyPom (Default: false)", 2 );
                append( sb, "Also copy the pom of each artifact.", 3 );
                append( sb, "Expression: ${mdep.copyPom}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "failOnMissingClassifierArtifact (Default: true)", 2 );
                append( sb, "This only applies if the classifier parameter is used.", 3 );
                append( sb, "Expression: ${mdep.failOnMissingClassifierArtifact}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/dependency)", 2 );
                append( sb, "Default location used for mojo unless overridden in ArtifactItem", 3 );
                append( sb, "Expression: ${outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "stripVersion (Default: false)", 2 );
                append( sb, "Strip artifact version during copy", 3 );
                append( sb, "Expression: ${mdep.stripVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );

                append( sb, "useRepositoryLayout (Default: false)", 2 );
                append( sb, "Place each artifact in the same directory layout as a default repository.\nexample: /outputDirectory/junit/junit/3.8.1/junit-3.8.1.jar", 3 );
                append( sb, "Expression: ${mdep.useRepositoryLayout}", 3 );
                append( sb, "", 0 );

                append( sb, "useSubDirectoryPerArtifact (Default: false)", 2 );
                append( sb, "Place each file in a separate subdirectory. (example /outputDirectory/junit-3.8.1-jar)", 3 );
                append( sb, "Expression: ${mdep.useSubDirectoryPerArtifact}", 3 );
                append( sb, "", 0 );

                append( sb, "useSubDirectoryPerScope (Default: false)", 2 );
                append( sb, "Place each type of file in a separate subdirectory. (example /outputDirectory/runtime /outputDirectory/provided etc)", 3 );
                append( sb, "Expression: ${mdep.useSubDirectoryPerScope}", 3 );
                append( sb, "", 0 );

                append( sb, "useSubDirectoryPerType (Default: false)", 2 );
                append( sb, "Place each type of file in a separate subdirectory. (example /outputDirectory/jars /outputDirectory/wars etc)", 3 );
                append( sb, "Expression: ${mdep.useSubDirectoryPerType}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "get".equals( goal ) )
        {
            append( sb, "dependency:get", 0 );
            append( sb, "Downloads a single artifact transitively from a specified remote repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifact", 2 );
                append( sb, "A string of the form groupId:artifactId:version[:packaging][:classifier].", 3 );
                append( sb, "Expression: ${artifact}", 3 );
                append( sb, "", 0 );

                append( sb, "artifactId", 2 );
                append( sb, "The artifactId of the artifact to download", 3 );
                append( sb, "Expression: ${artifactId}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "The classifier of the artifact to download. Ignored if artifact is used.", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "groupId", 2 );
                append( sb, "The groupId of the artifact to download", 3 );
                append( sb, "Expression: ${groupId}", 3 );
                append( sb, "", 0 );

                append( sb, "packaging (Default: jar)", 2 );
                append( sb, "The packaging of the artifact to download", 3 );
                append( sb, "Expression: ${packaging}", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryId (Default: temp)", 2 );
                append( sb, "The id of the repository from which we\'ll download the artifact", 3 );
                append( sb, "Expression: ${repoId}", 3 );
                append( sb, "", 0 );

                append( sb, "repositoryUrl", 2 );
                append( sb, "The url of the repository from which we\'ll download the artifact", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${repoUrl}", 3 );
                append( sb, "", 0 );

                append( sb, "transitive (Default: true)", 2 );
                append( sb, "Download transitively, retrieving the specified artifact and all of its dependencies.", 3 );
                append( sb, "Expression: {$transitive}", 3 );
                append( sb, "", 0 );

                append( sb, "version", 2 );
                append( sb, "The version of the artifact to download", 3 );
                append( sb, "Expression: ${version}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "go-offline".equals( goal ) )
        {
            append( sb, "dependency:go-offline", 0 );
            append( sb, "Goal that resolves all project dependencies, including plugins and reports and their dependencies.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendOutput (Default: false)", 2 );
                append( sb, "Whether to append outputs into the output file or overwrite it.", 3 );
                append( sb, "Expression: ${appendOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "If specified, this parameter will cause the dependencies to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "dependency:help", 0 );
            append( sb, "Display help information on maven-dependency-plugin.\nCall\n\u00a0\u00a0mvn\u00a0dependency:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "list".equals( goal ) )
        {
            append( sb, "dependency:list", 0 );
            append( sb, "Displays the list of dependencies for this project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendOutput (Default: false)", 2 );
                append( sb, "Whether to append outputs into the output file or overwrite it.", 3 );
                append( sb, "Expression: ${appendOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "If specified, this parameter will cause the dependencies to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputScope (Default: true)", 2 );
                append( sb, "If we should display the scope when resolving", 3 );
                append( sb, "Expression: ${mdep.outputScope}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "list-repositories".equals( goal ) )
        {
            append( sb, "dependency:list-repositories", 0 );
            append( sb, "Goal that resolves all project dependencies and then lists the repositories used by the build and by the transitive dependencies", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "properties".equals( goal ) )
        {
            append( sb, "dependency:properties", 0 );
            append( sb, "Goal that sets a property pointing to the artifact file for each project dependency. For each dependency (direct and transitive) a project property will be set which follows the form groupId:artifactId:type:[classifier] and contains the path to the resolved artifact.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "purge-local-repository".equals( goal ) )
        {
            append( sb, "dependency:purge-local-repository", 0 );
            append( sb, "Remove the project dependencies from the local repository, and optionally re-resolve them.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "actTransitively (Default: true)", 2 );
                append( sb, "Whether this mojo should act on all transitive dependencies. Default value is true.", 3 );
                append( sb, "Expression: ${actTransitively}", 3 );
                append( sb, "", 0 );

                append( sb, "exclude", 2 );
                append( sb, "Comma-separated list of groupId:artifactId entries, which should be used to exclude artifacts from deletion/refresh. This is a command-line alternative to the excludes parameter, since List parameters are not currently compatible with CLI specification.", 3 );
                append( sb, "Expression: ${exclude}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "The list of dependencies in the form of groupId:artifactId which should NOT be deleted/refreshed. This is useful for third-party artifacts.", 3 );
                append( sb, "", 0 );

                append( sb, "reResolve (Default: true)", 2 );
                append( sb, "Whether to re-resolve the artifacts once they have been deleted from the local repository. If you are running this mojo from the command-line, you may want to disable this. By default, artifacts will be re-resolved.", 3 );
                append( sb, "Expression: ${reResolve}", 3 );
                append( sb, "", 0 );

                append( sb, "resolutionFuzziness (Default: file)", 2 );
                append( sb, "Determines how liberally the plugin will delete an artifact from the local repository. Values are:\n\n-\tfile (default) - Eliminate only the artifact\'s file.\n-\tversion - Eliminate all files associated with the artifact\'s version.\n-\tartifactId - Eliminate all files associated with the artifact\'s artifactId.\n-\tgroupId - Eliminate all files associated with the artifact\'s groupId.\n", 3 );
                append( sb, "Expression: ${resolutionFuzziness}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Whether this plugin should output verbose messages. Default is false.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resolve".equals( goal ) )
        {
            append( sb, "dependency:resolve", 0 );
            append( sb, "Goal that resolves the project dependencies from the repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendOutput (Default: false)", 2 );
                append( sb, "Whether to append outputs into the output file or overwrite it.", 3 );
                append( sb, "Expression: ${appendOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "If specified, this parameter will cause the dependencies to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputScope (Default: true)", 2 );
                append( sb, "If we should display the scope when resolving", 3 );
                append( sb, "Expression: ${mdep.outputScope}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "resolve-plugins".equals( goal ) )
        {
            append( sb, "dependency:resolve-plugins", 0 );
            append( sb, "Goal that resolves all project plugins and reports and their dependencies.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendOutput (Default: false)", 2 );
                append( sb, "Whether to append outputs into the output file or overwrite it.", 3 );
                append( sb, "Expression: ${appendOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "If specified, this parameter will cause the dependencies to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "sources".equals( goal ) )
        {
            append( sb, "dependency:sources", 0 );
            append( sb, "Goal that resolves the project source dependencies from the repository.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendOutput (Default: false)", 2 );
                append( sb, "Whether to append outputs into the output file or overwrite it.", 3 );
                append( sb, "Expression: ${appendOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "If specified, this parameter will cause the dependencies to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "tree".equals( goal ) )
        {
            append( sb, "dependency:tree", 0 );
            append( sb, "Displays the dependency tree for this project.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "appendOutput (Default: false)", 2 );
                append( sb, "Whether to append outputs into the output file or overwrite it.", 3 );
                append( sb, "Expression: ${appendOutput}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma-separated list of artifacts to filter from the serialized dependency tree, or null not to filter any artifacts from the dependency tree. The artifact syntax is defined by StrictPatternExcludesArtifactFilter.", 3 );
                append( sb, "Expression: ${excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma-separated list of artifacts to filter the serialized dependency tree by, or null not to filter the dependency tree. The artifact syntax is defined by StrictPatternIncludesArtifactFilter.", 3 );
                append( sb, "Expression: ${includes}", 3 );
                append( sb, "", 0 );

                append( sb, "output", 2 );
                append( sb, "Deprecated. use outputFile instead.", 3 );
                append( sb, "", 0 );
                append( sb, "If specified, this parameter will cause the dependency tree to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${output}", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile", 2 );
                append( sb, "If specified, this parameter will cause the dependency tree to be written to the path specified, instead of writing to the console.", 3 );
                append( sb, "Expression: ${outputFile}", 3 );
                append( sb, "", 0 );

                append( sb, "outputType (Default: text)", 2 );
                append( sb, "If specified, this parameter will cause the dependency tree to be written using the specified format. Currently supported format are text, dot, graphml and tgf. These formats can be plotted to image files. An example of how to plot a dot file using pygraphviz can be found here", 3 );
                append( sb, "Expression: ${outputType}", 3 );
                append( sb, "", 0 );

                append( sb, "scope", 2 );
                append( sb, "The scope to filter by when resolving the dependency tree, or null to include dependencies from all scopes. Note that this feature does not currently work due to MNG-3236.", 3 );
                append( sb, "Expression: ${scope}", 3 );
                append( sb, "", 0 );

                append( sb, "tokens (Default: standard)", 2 );
                append( sb, "The token set name to use when outputting the dependency tree. Possible values are whitespace, standard or extended, which use whitespace, standard or extended ASCII sets respectively.", 3 );
                append( sb, "Expression: ${tokens}", 3 );
                append( sb, "", 0 );

                append( sb, "verbose (Default: false)", 2 );
                append( sb, "Whether to include omitted nodes in the serialized dependency tree.", 3 );
                append( sb, "Expression: ${verbose}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "unpack".equals( goal ) )
        {
            append( sb, "dependency:unpack", 0 );
            append( sb, "Goal that retrieves a list of artifacts from the repository and unpacks them in a defined location.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "artifactItems", 2 );
                append( sb, "Collection of ArtifactItems to work on. (ArtifactItem contains groupId, artifactId, version, type, classifier, location, destFileName, markerFile and overwrite.) See Usage for details.", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of file patterns to exclude when unpacking the artifact. i.e. **\\/*.xml,**\\/*.properties NOTE: Excludes patterns override the includes. (component code = return isIncluded( name ) AND !isExcluded( name );)", 3 );
                append( sb, "Expression: ${mdep.unpack.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of file patterns to include when unpacking the artifact. i.e. **\\/*.xml,**\\/*.properties NOTE: Excludes patterns override the includes. (component code = return isIncluded( name ) AND !isExcluded( name );)", 3 );
                append( sb, "Expression: ${mdep.unpack.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "localRepositoryDirectory", 2 );
                append( sb, "Path to override default local repository during plugin\'s execution. To remove all downloaded artifacts as part of the build, set this value to a location under your project\'s target directory", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory", 2 );
                append( sb, "Directory to store flag files after unpack", 3 );
                append( sb, "Expression: ${project.build.directory}/dependency-maven-plugin-markers", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/dependency)", 2 );
                append( sb, "Default location used for mojo unless overridden in ArtifactItem", 3 );
                append( sb, "Expression: ${outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite if newer", 3 );
                append( sb, "Expression: ${mdep.overIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${mdep.overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${mdep.overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip the execution", 3 );
                append( sb, "Expression: ${mdep.skip}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "unpack-dependencies".equals( goal ) )
        {
            append( sb, "dependency:unpack-dependencies", 0 );
            append( sb, "Goal that unpacks the project dependencies from the repository to a defined location.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "classifier", 2 );
                append( sb, "Specify classifier to look for. Example: sources", 3 );
                append( sb, "Expression: ${classifier}", 3 );
                append( sb, "", 0 );

                append( sb, "copyPom (Default: false)", 2 );
                append( sb, "Also copy the pom of each artifact.", 3 );
                append( sb, "Expression: ${mdep.copyPom}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names too exclude.", 3 );
                append( sb, "Expression: ${excludeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeGroupIds", 2 );
                append( sb, "Comma separated list of GroupId Names to exclude.", 3 );
                append( sb, "Expression: ${excludeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A comma separated list of file patterns to exclude when unpacking the artifact. i.e. **\\/*.xml,**\\/*.properties NOTE: Excludes patterns override the includes. (component code = return isIncluded( name ) AND !isExcluded( name );)", 3 );
                append( sb, "Expression: ${mdep.unpack.excludes}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeScope", 2 );
                append( sb, "Scope to exclude. An Empty string indicates no scopes (default).", 3 );
                append( sb, "Expression: ${excludeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTransitive (Default: false)", 2 );
                append( sb, "If we should exclude transitive dependencies", 3 );
                append( sb, "Expression: ${excludeTransitive}", 3 );
                append( sb, "", 0 );

                append( sb, "excludeTypes", 2 );
                append( sb, "Comma Separated list of Types to exclude. Empty String indicates don\'t exclude anything (default).", 3 );
                append( sb, "Expression: ${excludeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "failOnMissingClassifierArtifact (Default: true)", 2 );
                append( sb, "This only applies if the classifier parameter is used.", 3 );
                append( sb, "Expression: ${mdep.failOnMissingClassifierArtifact}", 3 );
                append( sb, "", 0 );

                append( sb, "includeArtifactIds", 2 );
                append( sb, "Comma separated list of Artifact names to include.", 3 );
                append( sb, "Expression: ${includeArtifactIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includeClassifiers", 2 );
                append( sb, "Comma Separated list of Classifiers to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeClassifiers}", 3 );
                append( sb, "", 0 );

                append( sb, "includeGroupIds", 2 );
                append( sb, "Comma separated list of GroupIds to include.", 3 );
                append( sb, "Expression: ${includeGroupIds}", 3 );
                append( sb, "", 0 );

                append( sb, "includes", 2 );
                append( sb, "A comma separated list of file patterns to include when unpacking the artifact. i.e. **\\/*.xml,**\\/*.properties NOTE: Excludes patterns override the includes. (component code = return isIncluded( name ) AND !isExcluded( name );)", 3 );
                append( sb, "Expression: ${mdep.unpack.includes}", 3 );
                append( sb, "", 0 );

                append( sb, "includeScope", 2 );
                append( sb, "Scope to include. An Empty string indicates all scopes (default).", 3 );
                append( sb, "Expression: ${includeScope}", 3 );
                append( sb, "", 0 );

                append( sb, "includeTypes", 2 );
                append( sb, "Comma Separated list of Types to include. Empty String indicates include everything (default).", 3 );
                append( sb, "Expression: ${includeTypes}", 3 );
                append( sb, "", 0 );

                append( sb, "markersDirectory (Default: ${project.build.directory}/dependency-maven-plugin-markers)", 2 );
                append( sb, "Directory to store flag files", 3 );
                append( sb, "Expression: ${markersDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "outputAbsoluteArtifactFilename (Default: false)", 2 );
                append( sb, "Output absolute filename for resolved artifacts", 3 );
                append( sb, "Expression: ${outputAbsoluteArtifactFilename}", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.build.directory}/dependency)", 2 );
                append( sb, "Default location used for mojo unless overridden in ArtifactItem", 3 );
                append( sb, "Expression: ${outputDirectory}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteIfNewer (Default: true)", 2 );
                append( sb, "Overwrite artifacts that don\'t exist or are older than the source.", 3 );
                append( sb, "Expression: ${overWriteIfNewer}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteReleases (Default: false)", 2 );
                append( sb, "Overwrite release artifacts", 3 );
                append( sb, "Expression: ${overWriteReleases}", 3 );
                append( sb, "", 0 );

                append( sb, "overWriteSnapshots (Default: false)", 2 );
                append( sb, "Overwrite snapshot artifacts", 3 );
                append( sb, "Expression: ${overWriteSnapshots}", 3 );
                append( sb, "", 0 );

                append( sb, "prependGroupId (Default: false)", 2 );
                append( sb, "Prepend the groupId during copy.", 3 );
                append( sb, "Expression: ${mdep.prependGroupId}", 3 );
                append( sb, "", 0 );

                append( sb, "silent (Default: false)", 2 );
                append( sb, "If the plugin should be silent.", 3 );
                append( sb, "Expression: ${silent}", 3 );
                append( sb, "", 0 );

                append( sb, "stripVersion (Default: false)", 2 );
                append( sb, "Strip artifact version during copy", 3 );
                append( sb, "Expression: ${mdep.stripVersion}", 3 );
                append( sb, "", 0 );

                append( sb, "type (Default: java-source)", 2 );
                append( sb, "Specify type to look for when constructing artifact based on classifier. Example: java-source,jar,war", 3 );
                append( sb, "Expression: ${type}", 3 );
                append( sb, "", 0 );

                append( sb, "useRepositoryLayout (Default: false)", 2 );
                append( sb, "Place each artifact in the same directory layout as a default repository.\nexample: /outputDirectory/junit/junit/3.8.1/junit-3.8.1.jar", 3 );
                append( sb, "Expression: ${mdep.useRepositoryLayout}", 3 );
                append( sb, "", 0 );

                append( sb, "useSubDirectoryPerArtifact (Default: false)", 2 );
                append( sb, "Place each file in a separate subdirectory. (example /outputDirectory/junit-3.8.1-jar)", 3 );
                append( sb, "Expression: ${mdep.useSubDirectoryPerArtifact}", 3 );
                append( sb, "", 0 );

                append( sb, "useSubDirectoryPerScope (Default: false)", 2 );
                append( sb, "Place each type of file in a separate subdirectory. (example /outputDirectory/runtime /outputDirectory/provided etc)", 3 );
                append( sb, "Expression: ${mdep.useSubDirectoryPerScope}", 3 );
                append( sb, "", 0 );

                append( sb, "useSubDirectoryPerType (Default: false)", 2 );
                append( sb, "Place each type of file in a separate subdirectory. (example /outputDirectory/jars /outputDirectory/wars etc)", 3 );
                append( sb, "Expression: ${mdep.useSubDirectoryPerType}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
