package org.apache.maven.plugin.checkstyle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-checkstyle-plugin.<br/> Call <pre>  mvn checkstyle:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Fri Jul 10 12:31:42 CEST 2009
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.4.3)
 * @goal help
 * @requiresProject false
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.apache.maven.plugins:maven-checkstyle-plugin:2.3", 0 );
        append( sb, "", 0 );

        append( sb, "Maven Checkstyle Plugin 2.3", 0 );
        append( sb, "Generates a report on violations of code style and optionally fails the build if violations are detected.", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 3 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "check".equals( goal ) )
        {
            append( sb, "checkstyle:check", 0 );
            append( sb, "Perform a violation check against the last Checkstyle run to see if there are any violations. It reads the Checkstyle output file, counts the number of violations found and displays it on the console.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "failOnViolation (Default: true)", 2 );
                append( sb, "Do we fail the build on a violation?", 3 );
                append( sb, "", 0 );

                append( sb, "logViolationsToConsole (Default: false)", 2 );
                append( sb, "Output the detected violations to the console.", 3 );
                append( sb, "", 0 );

                append( sb, "maxAllowedViolations (Default: 0)", 2 );
                append( sb, "The maximum number of allowed violations. The execution fails only if the number of violations is above this limit.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile (Default: ${project.build.directory}/checkstyle-result.xml)", 2 );
                append( sb, "Specifies the path and filename to save the Checkstyle output. The format of the output file is determined by the outputFileFormat parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileFormat (Default: xml)", 2 );
                append( sb, "Specifies the format of the output to be used when writing to the output file. Valid values are \'plain\' and \'xml\'.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );

                append( sb, "violationSeverity (Default: error)", 2 );
                append( sb, "The lowest severity level that is considered a violation. Valid values are \'error\', \'warning\' and \'info\'.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "checkstyle".equals( goal ) )
        {
            append( sb, "checkstyle:checkstyle", 0 );
            append( sb, "Perform a Checkstyle analysis, and generate a report on violations.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "cacheFile (Default: ${project.build.directory}/checkstyle-cachefile)", 2 );
                append( sb, "Specifies the cache file used to speed up Checkstyle on successive runs.", 3 );
                append( sb, "", 0 );

                append( sb, "configLocation (Default: config/sun_checks.xml)", 2 );
                append( sb, "Specifies the location of the XML configuration to use.\n\nPotential values are a filesystem path, a URL, or a classpath resource. This parameter expects that the contents of the location conform to the xml format (Checkstyle Checker module) configuration of rulesets.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the configuration is copied into the ${project.build.directory}/checkstyle-configuration.xml file before being passed to Checkstyle as a configuration.\n\nThere are 4 predefined rulesets.\n\n-\tconfig/sun_checks.xml: Sun Checks.\n-\tconfig/turbine_checks.xml: Turbine Checks.\n-\tconfig/avalon_checks.xml: Avalon Checks.\n-\tconfig/maven_checks.xml: Maven Source Checks.\n", 3 );
                append( sb, "", 0 );

                append( sb, "consoleOutput (Default: false)", 2 );
                append( sb, "Output errors to console.", 3 );
                append( sb, "", 0 );

                append( sb, "enableFilesSummary (Default: true)", 2 );
                append( sb, "Specifies if the Files summary should be enabled or not.", 3 );
                append( sb, "", 0 );

                append( sb, "enableRSS (Default: true)", 2 );
                append( sb, "Specifies if the RSS should be enabled or not.", 3 );
                append( sb, "", 0 );

                append( sb, "enableRulesSummary (Default: true)", 2 );
                append( sb, "Specifies if the Rules summary should be enabled or not.", 3 );
                append( sb, "", 0 );

                append( sb, "enableSeveritySummary (Default: true)", 2 );
                append( sb, "Specifies if the Severity summary should be enabled or not.", 3 );
                append( sb, "", 0 );

                append( sb, "encoding (Default: ${project.build.sourceEncoding})", 2 );
                append( sb, "The file encoding to use when reading the source files. If the property project.build.sourceEncoding is not set, the platform default encoding is used. Note: This parameter always overrides the property charset from Checkstyle\'s TreeWalker module.", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "Specifies the names filter of the source files to be excluded for Checkstyle.", 3 );
                append( sb, "", 0 );

                append( sb, "failsOnError (Default: false)", 2 );
                append( sb, "Specifies if the build should fail upon a violation.", 3 );
                append( sb, "", 0 );

                append( sb, "format (Default: sun)", 2 );
                append( sb, "Deprecated. Use configLocation instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies what predefined check set to use. Available sets are \'sun\' (for the Sun coding conventions), \'turbine\', and \'avalon\'.", 3 );
                append( sb, "", 0 );

                append( sb, "headerFile", 2 );
                append( sb, "Deprecated. Use headerLocation instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the location of the License file (a.k.a. the header file) that is used by Checkstyle to verify that source code has the correct license header.", 3 );
                append( sb, "", 0 );

                append( sb, "headerLocation (Default: LICENSE.txt)", 2 );
                append( sb, "Specifies the location of the License file (a.k.a. the header file) that can be used by Checkstyle to verify that source code has the correct license header.\n\nYou need to use ${checkstyle.header.file} in your Checkstyle xml configuration to reference the name of this header file.\n\nFor instance:\n\n<module name=\'RegexpHeader\'> <property name=\'headerFile\' value=\'${checkstyle.header.file}\'/> </module>\n", 3 );
                append( sb, "", 0 );

                append( sb, "includeTestSourceDirectory (Default: ${false})", 2 );
                append( sb, "Include or not the test source directory to be used for Checkstyle.", 3 );
                append( sb, "", 0 );

                append( sb, "includes (Default: **/*.java)", 2 );
                append( sb, "Specifies the names filter of the source files to be used for Checkstyle.", 3 );
                append( sb, "", 0 );

                append( sb, "linkXRef (Default: true)", 2 );
                append( sb, "Link the violation line numbers to the source xref. Will link automatically if Maven JXR plugin is being used.", 3 );
                append( sb, "", 0 );

                append( sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2 );
                append( sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in Maven Site Plugin is used instead.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFile (Default: ${project.build.directory}/checkstyle-result.xml)", 2 );
                append( sb, "Specifies the path and filename to save the checkstyle output. The format of the output file is determined by the outputFileFormat parameter.", 3 );
                append( sb, "", 0 );

                append( sb, "outputFileFormat (Default: xml)", 2 );
                append( sb, "Specifies the format of the output to be used when writing to the output file. Valid values are \'plain\' and \'xml\'.", 3 );
                append( sb, "", 0 );

                append( sb, "packageNamesFile", 2 );
                append( sb, "Deprecated. Use packageNamesLocation instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the location of the package names XML to be used to configure Checkstyle.", 3 );
                append( sb, "", 0 );

                append( sb, "packageNamesLocation", 2 );
                append( sb, "Specifies the location of the package names XML to be used to configure the Checkstyle Packages.\n\nThis parameter is resolved as resource, URL, then file. If resolved to a resource, or a URL, the contents of the package names XML is copied into the ${project.build.directory}/checkstyle-packagenames.xml file before being passed to Checkstyle for loading.\n", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesFile", 2 );
                append( sb, "Deprecated. Use propertiesLocation instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the location of the Checkstyle properties file that will be used to check the source.", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesLocation", 2 );
                append( sb, "Specifies the location of the properties file.\n\nThis parameter is resolved as URL, File then resource. If successfully resolved, the contents of the properties location is copied into the ${project.build.directory}/checkstyle-checker.properties file before being passed to Checkstyle for loading.\n\nThe contents of the propertiesLocation will be made available to Checkstyle for specifying values for parameters within the xml configuration (specified in the configLocation parameter).\n", 3 );
                append( sb, "", 0 );

                append( sb, "propertiesURL", 2 );
                append( sb, "Deprecated. Use propertiesLocation instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the URL of the Checkstyle properties that will be used to check the source.", 3 );
                append( sb, "", 0 );

                append( sb, "propertyExpansion", 2 );
                append( sb, "Allows for specifying raw property expansion information.", 3 );
                append( sb, "", 0 );

                append( sb, "skip (Default: false)", 2 );
                append( sb, "Skip entire check.", 3 );
                append( sb, "", 0 );

                append( sb, "sourceDirectory (Default: ${project.build.sourceDirectory})", 2 );
                append( sb, "Specifies the location of the source directory to be used for Checkstyle.", 3 );
                append( sb, "", 0 );

                append( sb, "suppressionsFile", 2 );
                append( sb, "Deprecated. Use suppressionsLocation instead.", 3 );
                append( sb, "", 0 );
                append( sb, "Specifies the location of the suppressions XML file to use. The plugin defines a Checkstyle property named checkstyle.suppressions.file with the value of this property. This allows using the Checkstyle property in your own custom checkstyle configuration file when specifying a suppressions file.", 3 );
                append( sb, "", 0 );

                append( sb, "suppressionsFileExpression (Default: checkstyle.suppressions.file)", 2 );
                append( sb, "The key to be used in the properties for the suppressions file.", 3 );
                append( sb, "", 0 );

                append( sb, "suppressionsLocation", 2 );
                append( sb, "Specifies the location of the suppressions XML file to use.\n\nThis parameter is resolved as resource, URL, then file. If successfully resolved, the contents of the suppressions XML is copied into the ${project.build.directory}/checkstyle-supressions.xml file before being passed to Checkstyle for loading.\n\nSee suppressionsFileExpression for the property that will be made available to your checkstyle configuration.\n", 3 );
                append( sb, "", 0 );

                append( sb, "testSourceDirectory (Default: ${project.build.testSourceDirectory})", 2 );
                append( sb, "Specifies the location of the test source directory to be used for Checkstyle.", 3 );
                append( sb, "", 0 );

                append( sb, "useFile", 2 );
                append( sb, "If null, the Checkstyle plugin will display violations on stdout. Otherwise, a text file will be created with the violations.", 3 );
                append( sb, "", 0 );

                append( sb, "xrefLocation (Default: ${project.reporting.outputDirectory}/xref)", 2 );
                append( sb, "Location of the Xrefs to link to.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "checkstyle:help", 0 );
            append( sb, "Display help information on maven-checkstyle-plugin.\nCall\n\u00a0\u00a0mvn\u00a0checkstyle:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
