// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from merger.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.toolchain.v4;

import java.io.ObjectStreamException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.toolchain.PersistedToolchains;
import org.apache.maven.api.toolchain.ToolchainModel;

@Generated
public class MavenToolchainsMerger
{

    private final boolean deepMerge;

    public MavenToolchainsMerger() {
        this(true);
    }

    public MavenToolchainsMerger(boolean deepMerge) {
        this.deepMerge = deepMerge;
    }

    /**
     * Merges the specified source object into the given target object.
     *
     * @param target The target object whose existing contents should be merged with the source, must not be
     *            <code>null</code>.
     * @param source The (read-only) source object that should be merged into the target object, may be
     *            <code>null</code>.
     * @param sourceDominant A flag indicating whether either the target object or the source object provides the
     *            dominant data.
     * @param hints A set of key-value pairs that customized merger implementations can use to carry domain-specific
     *            information along, may be <code>null</code>.
     */
    public PersistedToolchains merge( PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<?, ?> hints )
    {
        Objects.requireNonNull( target, "target cannot be null" );
        if ( source == null )
        {
            return target;
        }
        Map<Object, Object> context = new HashMap<>();
        if ( hints != null )
        {
            context.putAll( hints );
        }
        return mergePersistedToolchains( target, source, sourceDominant, context );
    }

    protected TrackableBase mergeTrackableBase( TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context )
    {
        TrackableBase.Builder builder = TrackableBase.newBuilder( target );
        mergeTrackableBase( builder, target, source, sourceDominant, context );
        return builder.build();
    }

    protected void mergeTrackableBase( TrackableBase.Builder builder, TrackableBase target, TrackableBase source, boolean sourceDominant, Map<Object, Object> context )
    {
    }


    protected PersistedToolchains mergePersistedToolchains( PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<Object, Object> context )
    {
        PersistedToolchains.Builder builder = PersistedToolchains.newBuilder( target );
        mergePersistedToolchains( builder, target, source, sourceDominant, context );
        return builder.build();
    }

    protected void mergePersistedToolchains( PersistedToolchains.Builder builder, PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<Object, Object> context )
    {
        mergeTrackableBase( builder, target ,source, sourceDominant, context );
        mergePersistedToolchains_Toolchains( builder, target, source, sourceDominant, context );
    }

    protected void mergePersistedToolchains_Toolchains( PersistedToolchains.Builder builder, PersistedToolchains target, PersistedToolchains source, boolean sourceDominant, Map<Object, Object> context )
    {
        if (deepMerge) {
            builder.toolchains( merge( target.getToolchains(), source.getToolchains(), getToolchainModelKey(),
                    ( t, s ) -> mergeToolchainModel( t, s, sourceDominant, context ) ) );
        } else {
            builder.toolchains( merge( target.getToolchains(), source.getToolchains(), sourceDominant, getToolchainModelKey() ) );
        }
    }

    protected ToolchainModel mergeToolchainModel( ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context )
    {
        ToolchainModel.Builder builder = ToolchainModel.newBuilder( target );
        mergeToolchainModel( builder, target, source, sourceDominant, context );
        return builder.build();
    }

    protected void mergeToolchainModel( ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context )
    {
        mergeTrackableBase( builder, target ,source, sourceDominant, context );
        mergeToolchainModel_Type( builder, target, source, sourceDominant, context );
        mergeToolchainModel_Provides( builder, target, source, sourceDominant, context );
        mergeToolchainModel_Configuration( builder, target, source, sourceDominant, context );
    }

    protected void mergeToolchainModel_Type( ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context )
    {
        String src = source.getType();
        String tgt = target.getType();
        if ( src != null && ( sourceDominant || tgt == null ) )
        {
            builder.type( src );
        }
    }
    protected void mergeToolchainModel_Provides( ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context )
    {
        Map<String, String> src = source.getProvides();
        if ( !src.isEmpty() )
        {
            Map<String, String> tgt = target.getProvides();
            if ( tgt.isEmpty() )
            {
                builder.provides( src );
            }
            else
            {
                Map<String, String> merged = new HashMap<>();
                merged.putAll( sourceDominant ? target.getProvides() : source.getProvides() );
                merged.putAll( sourceDominant ? source.getProvides() : target.getProvides() );
                builder.provides( merged );
            }
        }
    }
    protected void mergeToolchainModel_Configuration( ToolchainModel.Builder builder, ToolchainModel target, ToolchainModel source, boolean sourceDominant, Map<Object, Object> context )
    {
        XmlNode src = source.getConfiguration();
        if ( src != null )
        {
            XmlNode tgt = target.getConfiguration();
            if ( tgt == null )
            {
                builder.configuration( src );
            }
            else if ( sourceDominant )
            {
                builder.configuration( src.merge( tgt ) );
            }
            else
            {
                builder.configuration( tgt.merge( src ) );
            }
        }
    }


    protected KeyComputer<TrackableBase> getTrackableBaseKey()
    {
        return v -> v;
    }
    protected KeyComputer<PersistedToolchains> getPersistedToolchainsKey()
    {
        return v -> v;
    }
    protected KeyComputer<ToolchainModel> getToolchainModelKey()
    {
        return v -> v;
    }

    /**
     * Use to compute keys for data structures
     * @param <T> the data structure type
     */
    @FunctionalInterface
    public interface KeyComputer<T> extends Function<T, Object>
    {
    }

    /**
     * Merge two lists
     */
    public static <T> List<T> merge( List<T> tgt, List<T> src, boolean sourceDominant, KeyComputer<T> computer )
    {
        return merge( tgt, src, computer, ( t, s ) -> sourceDominant ? s : t );
    }

    public static <T> List<T> merge( List<T> tgt, List<T> src, KeyComputer<T> computer, BinaryOperator<T> remapping )
    {
        if ( src.isEmpty() )
        {
            return tgt;
        }

        MergingList<T> list;
        if ( tgt instanceof MergingList )
        {
            list = (MergingList<T>) tgt;
        }
        else
        {
            list = new MergingList<>( computer, src.size() + tgt.size() );
            list.mergeAll( tgt, ( t, s ) -> s );
        }

        list.mergeAll( src, remapping );
        return list;
    }

    /**
     * Merging list
     * @param <V>
     */
    private static class MergingList<V> extends AbstractList<V> implements java.io.Serializable
    {

        private final KeyComputer<V> keyComputer;
        private Map<Object, V> map;
        private List<V> list;

        MergingList( KeyComputer<V> keyComputer, int initialCapacity )
        {
            this.map = new LinkedHashMap<>( initialCapacity );
            this.keyComputer = keyComputer;
        }

        Object writeReplace() throws ObjectStreamException
        {
            return new ArrayList<>( this );
        }

        @Override
        public Iterator<V> iterator()
        {
            if ( map != null )
            {
                return map.values().iterator();
            }
            else
            {
                return list.iterator();
            }
        }

        void mergeAll( Collection<V> vs, BinaryOperator<V> remapping )
        {
            if ( map == null )
            {
                map = list.stream().collect( Collectors.toMap( keyComputer,
                                                               Function.identity(),
                                                               null,
                                                               LinkedHashMap::new ) );

                list = null;
            }

            if ( vs instanceof MergingList && ( (MergingList<V>) vs ).map != null )
            {
                for ( Map.Entry<Object, V> e : ( (MergingList<V>) vs ).map.entrySet() )
                {
                    Object key = e.getKey();
                    V v = e.getValue();
                    map.merge( key, v, remapping );
                }
            }
            else
            {
                for ( V v : vs )
                {
                    Object key = keyComputer.apply( v );

                    map.merge( key, v, remapping );
                }
            }
        }

        @Override
        public boolean contains( Object o )
        {
            if ( map != null )
            {
                return map.containsValue( o );
            }
            else
            {
                return list.contains( o );
            }
        }

        private List<V> asList()
        {
            if ( list == null )
            {
                list = new ArrayList<>( map.values() );
                map = null;
            }
            return list;
        }

        @Override
        public void add( int index, V element )
        {
            asList().add( index, element );
        }

        @Override
        public V remove( int index )
        {
            return asList().remove( index );
        }

        @Override
        public V get( int index )
        {
            return asList().get( index );
        }

        @Override
        public int size()
        {
            if ( map != null )
            {
                return map.size();
            }
            else
            {
                return list.size();
            }
        }
    }
}
