/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.generator;

import java.io.PrintWriter;
import java.io.Writer;

public class PrettyPrintXMLWriter
extends org.codehaus.plexus.util.xml.PrettyPrintXMLWriter {
    private static final String LS = System.getProperty("line.separator");
    private PrintWriter writer;
    private String lineIndenter;
    private int depth;

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter) {
        this(writer, lineIndenter, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndenter) {
        this(new PrintWriter(writer), lineIndenter);
    }

    public PrettyPrintXMLWriter(PrintWriter writer) {
        this(writer, null, null);
    }

    public PrettyPrintXMLWriter(Writer writer) {
        this(new PrintWriter(writer));
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String lineIndenter, String encoding, String doctype) {
        super(writer, lineIndenter, encoding, doctype);
        this.setWriter(writer);
        this.setLineIndenter(lineIndenter);
    }

    public PrettyPrintXMLWriter(Writer writer, String lineIndenter, String encoding, String doctype) {
        this(new PrintWriter(writer), lineIndenter, encoding, doctype);
    }

    public PrettyPrintXMLWriter(PrintWriter writer, String encoding, String doctype) {
        this(writer, "  ", encoding, doctype);
    }

    public PrettyPrintXMLWriter(Writer writer, String encoding, String doctype) {
        this(new PrintWriter(writer), encoding, doctype);
    }

    private void write(String str) {
        this.getWriter().write(str);
    }

    protected String getLineIndenter() {
        return this.lineIndenter;
    }

    protected void setLineIndenter(String lineIndenter) {
        this.lineIndenter = lineIndenter;
    }

    protected void endOfLine() {
        this.write(LS);
        for (int i = 0; i < this.getDepth(); ++i) {
            this.write(this.getLineIndenter());
        }
    }

    protected void setWriter(PrintWriter writer) {
        this.writer = writer;
    }

    protected PrintWriter getWriter() {
        return this.writer;
    }

    protected void setDepth(int depth) {
        this.depth = depth;
    }

    protected int getDepth() {
        return this.depth;
    }

    public void startElement(String name) {
        super.startElement(name);
        this.setDepth(this.getDepth() + 1);
    }

    public void endElement() {
        super.endElement();
        this.setDepth(this.getDepth() - 1);
    }
}

