// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * common base class that contains code to track the source for
 * this instance (USER|GLOBAL)
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class TrackableBase
    implements Serializable, InputLocationTracker
{
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    TrackableBase(
        Map<Object, InputLocation> locations
    ) {
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }

    /**
     * Creates a new {@code TrackableBase} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code TrackableBase}
     */
    @Nonnull
    public static TrackableBase newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code TrackableBase} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code TrackableBase}
     */
    @Nonnull
    public static TrackableBase newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code TrackableBase} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code TrackableBase} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code TrackableBase} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code TrackableBase} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(TrackableBase from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code TrackableBase} builder instance using the specified object as a basis.
     *
     * @param from the {@code TrackableBase} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(TrackableBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create TrackableBase instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        TrackableBase base;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(TrackableBase base, boolean forceCopy) {
            if (forceCopy) {
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public TrackableBase build() {
            if (base != null
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            return new TrackableBase(
                locations
            );
        }
    }


            
    public static final String USER_LEVEL = "user-level";
    public static final String PROJECT_LEVEL = "project-level";
    public static final String GLOBAL_LEVEL = "global-level";

    private String sourceLevel = USER_LEVEL;
    private boolean sourceLevelSet = false;

    public void setSourceLevel( String sourceLevel )
    {
        if ( sourceLevelSet )
        {
            throw new IllegalStateException( "Cannot reset sourceLevel attribute; it is already set to: " + sourceLevel );
        }
        else if ( !( USER_LEVEL.equals( sourceLevel ) || PROJECT_LEVEL.equals( sourceLevel )  || GLOBAL_LEVEL.equals( sourceLevel ) ) )
        {
            throw new IllegalArgumentException( "sourceLevel must be one of: {" + USER_LEVEL + "," + PROJECT_LEVEL + "," + GLOBAL_LEVEL + "}" );
        }
        else
        {
            this.sourceLevel = sourceLevel;
            this.sourceLevelSet = true;
        }
    }

    public String getSourceLevel()
    {
        return sourceLevel;
    }
            
          
}
