// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This is the file specification used to activate a profile. The missing value will be a the location
 * of a file that needs to exist, and if it doesn't the profile must run.  On the other hand exists will test
 * for the existence of the file and if it is there will run the profile.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ActivationFile
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the file that should be missing to activate a
     * profile.
     */
    final String missing;
    /**
     * The name of the file that should exist to activate a profile.
     */
    final String exists;
    /** Locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ActivationFile(
        String missing,
        String exists,
        Map<Object, InputLocation> locations
    ) {
        this.missing = missing;
        this.exists = exists;
        this.locations = ImmutableCollections.copy(locations);
    }

    /**
     * The name of the file that should be missing to activate a
     * profile.
     *
     * @return a {@code String}
     */
    public String getMissing() {
        return this.missing;
    }

    /**
     * The name of the file that should exist to activate a profile.
     *
     * @return a {@code String}
     */
    public String getExists() {
        return this.exists;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code ActivationFile} instance using the specified missing.
     *
     * @param missing the new {@code String} to use
     * @return a {@code ActivationFile} with the specified missing
     */
    @Nonnull
    public ActivationFile withMissing(String missing) {
        return newBuilder(this, true).missing(missing).build();
    }
    /**
     * Creates a new {@code ActivationFile} instance using the specified exists.
     *
     * @param exists the new {@code String} to use
     * @return a {@code ActivationFile} with the specified exists
     */
    @Nonnull
    public ActivationFile withExists(String exists) {
        return newBuilder(this, true).exists(exists).build();
    }

    /**
     * Creates a new {@code ActivationFile} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ActivationFile}
     */
    @Nonnull
    public static ActivationFile newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code ActivationFile} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ActivationFile}
     */
    @Nonnull
    public static ActivationFile newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code ActivationFile} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code ActivationFile} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code ActivationFile} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code ActivationFile} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ActivationFile from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code ActivationFile} builder instance using the specified object as a basis.
     *
     * @param from the {@code ActivationFile} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(ActivationFile from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create ActivationFile instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ActivationFile base;
        String missing;
        String exists;
        Map<Object, InputLocation> locations;

        Builder(boolean withDefaults) {
            if (withDefaults) {
            }
        }

        Builder(ActivationFile base, boolean forceCopy) {
            if (forceCopy) {
                this.missing = base.missing;
                this.exists = base.exists;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder missing(String missing) {
            this.missing = missing;
            return this;
        }

        @Nonnull
        public Builder exists(String exists) {
            this.exists = exists;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public ActivationFile build() {
            if (base != null
                    && (missing == null || missing == base.missing)
                    && (exists == null || exists == base.exists)
            ) {
                return base;
            }
            Map<Object, InputLocation> newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map<Object, InputLocation> oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            Map<Object, InputLocation> locations = new HashMap<>();
            locations.put("", newlocs.containsKey("") ? newlocs.get("") : oldlocs.get(""));
            locations.put("missing", newlocs.containsKey("missing") ? newlocs.get("missing") : oldlocs.get("missing"));
            locations.put("exists", newlocs.containsKey("exists") ? newlocs.get("exists") : oldlocs.get("exists"));
            return new ActivationFile(
                missing != null ? missing : (base != null ? base.missing : null),
                exists != null ? exists : (base != null ? base.exists : null),
                locations
            );
        }
    }

}
