// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The <code>&lt;proxy&gt;</code> element contains informations required to a proxy settings.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Proxy
    extends IdentifiableBase
    implements Serializable
{
    /**
     * Whether this proxy configuration is the active one.
     */
    final boolean active;
    /**
     * The proxy protocol.
     */
    final String protocol;
    /**
     * The proxy user.
     */
    final String username;
    /**
     * The proxy password.
     */
    final String password;
    /**
     * The proxy port.
     */
    final int port;
    /**
     * The proxy host.
     */
    final String host;
    /**
     * The list of non-proxied hosts (delimited by |).
     */
    final String nonProxyHosts;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Proxy(
        String id,
        boolean active,
        String protocol,
        String username,
        String password,
        int port,
        String host,
        String nonProxyHosts
    )
    {
        super(
            id
        );
        this.active = active;
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.port = port;
        this.host = host;
        this.nonProxyHosts = nonProxyHosts;
    }

    /**
     * Whether this proxy configuration is the active one.
     *
     * @return a {@code boolean}
     */
    public boolean isActive()
    {
        return this.active;
    }

    /**
     * The proxy protocol.
     *
     * @return a {@code String}
     */
    public String getProtocol()
    {
        return this.protocol;
    }

    /**
     * The proxy user.
     *
     * @return a {@code String}
     */
    public String getUsername()
    {
        return this.username;
    }

    /**
     * The proxy password.
     *
     * @return a {@code String}
     */
    public String getPassword()
    {
        return this.password;
    }

    /**
     * The proxy port.
     *
     * @return a {@code int}
     */
    public int getPort()
    {
        return this.port;
    }

    /**
     * The proxy host.
     *
     * @return a {@code String}
     */
    public String getHost()
    {
        return this.host;
    }

    /**
     * The list of non-proxied hosts (delimited by |).
     *
     * @return a {@code String}
     */
    public String getNonProxyHosts()
    {
        return this.nonProxyHosts;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Proxy} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Proxy} with the specified id
     */
    @Nonnull
    public Proxy withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified active.
     *
     * @param active the new {@code boolean} to use
     * @return a {@code Proxy} with the specified active
     */
    @Nonnull
    public Proxy withActive( boolean active )
    {
        return with().active( active ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified protocol.
     *
     * @param protocol the new {@code String} to use
     * @return a {@code Proxy} with the specified protocol
     */
    @Nonnull
    public Proxy withProtocol( String protocol )
    {
        return with().protocol( protocol ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified username.
     *
     * @param username the new {@code String} to use
     * @return a {@code Proxy} with the specified username
     */
    @Nonnull
    public Proxy withUsername( String username )
    {
        return with().username( username ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified password.
     *
     * @param password the new {@code String} to use
     * @return a {@code Proxy} with the specified password
     */
    @Nonnull
    public Proxy withPassword( String password )
    {
        return with().password( password ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified port.
     *
     * @param port the new {@code int} to use
     * @return a {@code Proxy} with the specified port
     */
    @Nonnull
    public Proxy withPort( int port )
    {
        return with().port( port ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified host.
     *
     * @param host the new {@code String} to use
     * @return a {@code Proxy} with the specified host
     */
    @Nonnull
    public Proxy withHost( String host )
    {
        return with().host( host ).build();
    }
    /**
     * Creates a new {@code Proxy} instance using the specified nonProxyHosts.
     *
     * @param nonProxyHosts the new {@code String} to use
     * @return a {@code Proxy} with the specified nonProxyHosts
     */
    @Nonnull
    public Proxy withNonProxyHosts( String nonProxyHosts )
    {
        return with().nonProxyHosts( nonProxyHosts ).build();
    }

    /**
     * Creates a new {@code Proxy} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Proxy}
     */
    @Nonnull
    public static Proxy newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Proxy} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Proxy}
     */
    @Nonnull
    public static Proxy newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Proxy} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Proxy} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Proxy} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Proxy} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Proxy from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Proxy} builder instance using the specified object as a basis.
     *
     * @param from the {@code Proxy} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Proxy from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Proxy instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends IdentifiableBase.Builder
    {
        Proxy base;
        Boolean active;
        String protocol;
        String username;
        String password;
        Integer port;
        String host;
        String nonProxyHosts;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.active = true;
                this.protocol = "http";
                this.port = 8080;
            }
        }

        Builder( Proxy base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.active = base.active;
                this.protocol = base.protocol;
                this.username = base.username;
                this.password = base.password;
                this.port = base.port;
                this.host = base.host;
                this.nonProxyHosts = base.nonProxyHosts;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder active( boolean active )
        {
            this.active = active;
            return this;
        }

        @Nonnull
        public Builder protocol( String protocol )
        {
            this.protocol = protocol;
            return this;
        }

        @Nonnull
        public Builder username( String username )
        {
            this.username = username;
            return this;
        }

        @Nonnull
        public Builder password( String password )
        {
            this.password = password;
            return this;
        }

        @Nonnull
        public Builder port( int port )
        {
            this.port = port;
            return this;
        }

        @Nonnull
        public Builder host( String host )
        {
            this.host = host;
            return this;
        }

        @Nonnull
        public Builder nonProxyHosts( String nonProxyHosts )
        {
            this.nonProxyHosts = nonProxyHosts;
            return this;
        }


        @Nonnull
        public Proxy build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( active == null || active == base.active )
                    && ( protocol == null || protocol == base.protocol )
                    && ( username == null || username == base.username )
                    && ( password == null || password == base.password )
                    && ( port == null || port == base.port )
                    && ( host == null || host == base.host )
                    && ( nonProxyHosts == null || nonProxyHosts == base.nonProxyHosts )
            )
            {
                return base;
            }
            return new Proxy(
                id != null ? id : ( base != null ? base.id : null ),
                active != null ? active : ( base != null ? base.active : true ),
                protocol != null ? protocol : ( base != null ? base.protocol : null ),
                username != null ? username : ( base != null ? base.username : null ),
                password != null ? password : ( base != null ? base.password : null ),
                port != null ? port : ( base != null ? base.port : 8080 ),
                host != null ? host : ( base != null ? base.host : null ),
                nonProxyHosts != null ? nonProxyHosts : ( base != null ? base.nonProxyHosts : null )
            );
        }
    }

}
