// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Contains the information needed for deploying websites.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Site
    implements Serializable, InputLocationTracker
{
    /**
     * A unique identifier for a deployment location. This is used to match the
     * site to configuration in the {@code settings.xml} file, for example.
     */
    final String id;
    /**
     * Human readable name of the deployment location.
     */
    final String name;
    /**
     * The url of the location where website is deployed, in the form {@code protocol://hostname/path}.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * site's {@code child.site.url.inherit.append.path="false"}
     */
    final String url;
    /**
     * When children inherit from distribution management site url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     */
    final String childSiteUrlInheritAppendPath;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field id. */
    final InputLocation idLocation;
    /** Location of the xml element for the field name. */
    final InputLocation nameLocation;
    /** Location of the xml element for the field url. */
    final InputLocation urlLocation;
    /** Location of the xml element for the field childSiteUrlInheritAppendPath. */
    final InputLocation childSiteUrlInheritAppendPathLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Site(
        String id,
        String name,
        String url,
        String childSiteUrlInheritAppendPath,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation idLocation,
        InputLocation nameLocation,
        InputLocation urlLocation,
        InputLocation childSiteUrlInheritAppendPathLocation
    )
    {
        this.id = id;
        this.name = name;
        this.url = url;
        this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.idLocation = idLocation;
        this.nameLocation = nameLocation;
        this.urlLocation = urlLocation;
        this.childSiteUrlInheritAppendPathLocation = childSiteUrlInheritAppendPathLocation;
    }

    /**
     * A unique identifier for a deployment location. This is used to match the
     * site to configuration in the {@code settings.xml} file, for example.
     *
     * @return a {@code String}
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * Human readable name of the deployment location.
     *
     * @return a {@code String}
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * The url of the location where website is deployed, in the form {@code protocol://hostname/path}.
     * <br><b>Default value is</b>: parent value [+ path adjustment] + (artifactId or project.directory property), or just parent value if
     * site's {@code child.site.url.inherit.append.path="false"}
     *
     * @return a {@code String}
     */
    public String getUrl()
    {
        return this.url;
    }

    /**
     * When children inherit from distribution management site url, append path or not? Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}
     * <br><b>Default value is</b>: {@code true}
     * <br><b>Since</b>: Maven 3.6.1
     *
     * @return a {@code String}
     */
    public String getChildSiteUrlInheritAppendPath()
    {
        return this.childSiteUrlInheritAppendPath;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "id":
                    return idLocation;
                case "name":
                    return nameLocation;
                case "url":
                    return urlLocation;
                case "childSiteUrlInheritAppendPath":
                    return childSiteUrlInheritAppendPathLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Site} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Site} with the specified id
     */
    @Nonnull
    public Site withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code Site} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code Site} with the specified name
     */
    @Nonnull
    public Site withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code Site} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code Site} with the specified url
     */
    @Nonnull
    public Site withUrl( String url )
    {
        return with().url( url ).build();
    }
    /**
     * Creates a new {@code Site} instance using the specified childSiteUrlInheritAppendPath.
     *
     * @param childSiteUrlInheritAppendPath the new {@code String} to use
     * @return a {@code Site} with the specified childSiteUrlInheritAppendPath
     */
    @Nonnull
    public Site withChildSiteUrlInheritAppendPath( String childSiteUrlInheritAppendPath )
    {
        return with().childSiteUrlInheritAppendPath( childSiteUrlInheritAppendPath ).build();
    }

    /**
     * Creates a new {@code Site} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Site}
     */
    @Nonnull
    public static Site newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Site} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Site}
     */
    @Nonnull
    public static Site newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Site} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Site} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Site} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Site} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Site from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Site} builder instance using the specified object as a basis.
     *
     * @param from the {@code Site} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Site from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Site instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Site base;
        String id;
        String name;
        String url;
        String childSiteUrlInheritAppendPath;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Site base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.childSiteUrlInheritAppendPath = base.childSiteUrlInheritAppendPath;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childSiteUrlInheritAppendPath( String childSiteUrlInheritAppendPath )
        {
            this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Site build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( name == null || name == base.name )
                    && ( url == null || url == base.url )
                    && ( childSiteUrlInheritAppendPath == null || childSiteUrlInheritAppendPath == base.childSiteUrlInheritAppendPath )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation idLocation = null;
            InputLocation nameLocation = null;
            InputLocation urlLocation = null;
            InputLocation childSiteUrlInheritAppendPathLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                idLocation = locations.remove( "id" );
                nameLocation = locations.remove( "name" );
                urlLocation = locations.remove( "url" );
                childSiteUrlInheritAppendPathLocation = locations.remove( "childSiteUrlInheritAppendPath" );
            }
            return new Site(
                id != null ? id : ( base != null ? base.id : null ),
                name != null ? name : ( base != null ? base.name : null ),
                url != null ? url : ( base != null ? base.url : null ),
                childSiteUrlInheritAppendPath != null ? childSiteUrlInheritAppendPath : ( base != null ? base.childSiteUrlInheritAppendPath : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                idLocation != null ? idLocation : ( base != null ? base.idLocation : null ),
                nameLocation != null ? nameLocation : ( base != null ? base.nameLocation : null ),
                urlLocation != null ? urlLocation : ( base != null ? base.urlLocation : null ),
                childSiteUrlInheritAppendPathLocation != null ? childSiteUrlInheritAppendPathLocation : ( base != null ? base.childSiteUrlInheritAppendPathLocation : null )
            );
        }
    }


            

    public boolean isChildSiteUrlInheritAppendPath()
    {
        return ( getChildSiteUrlInheritAppendPath() != null ) ? Boolean.parseBoolean( getChildSiteUrlInheritAppendPath() ) : true;
    }

            
          
}
