// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Download policy.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class RepositoryPolicy
    implements Serializable, InputLocationTracker
{
    /**
     * Whether to use this repository for downloading this type of artifact. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     */
    final String enabled;
    /**
     * The frequency for downloading updates - can be
     * {@code always,}
     * {@code daily}
     * (default),
     * {@code interval:XXX}
     * (in minutes) or
     * {@code never}
     * (only if it doesn't exist locally).
     */
    final String updatePolicy;
    /**
     * What to do when verification of an artifact checksum fails. Valid values are
     * {@code ignore},
     * {@code fail}
     * (default for Maven 4 and above) or
     * {@code warn}
     * (default for Maven 2 and 3)
     */
    final String checksumPolicy;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field enabled. */
    final InputLocation enabledLocation;
    /** Location of the xml element for the field updatePolicy. */
    final InputLocation updatePolicyLocation;
    /** Location of the xml element for the field checksumPolicy. */
    final InputLocation checksumPolicyLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    RepositoryPolicy(
        String enabled,
        String updatePolicy,
        String checksumPolicy,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation enabledLocation,
        InputLocation updatePolicyLocation,
        InputLocation checksumPolicyLocation
    )
    {
        this.enabled = enabled;
        this.updatePolicy = updatePolicy;
        this.checksumPolicy = checksumPolicy;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.enabledLocation = enabledLocation;
        this.updatePolicyLocation = updatePolicyLocation;
        this.checksumPolicyLocation = checksumPolicyLocation;
    }

    /**
     * Whether to use this repository for downloading this type of artifact. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code true}.
     *
     * @return a {@code String}
     */
    public String getEnabled()
    {
        return this.enabled;
    }

    /**
     * The frequency for downloading updates - can be
     * {@code always,}
     * {@code daily}
     * (default),
     * {@code interval:XXX}
     * (in minutes) or
     * {@code never}
     * (only if it doesn't exist locally).
     *
     * @return a {@code String}
     */
    public String getUpdatePolicy()
    {
        return this.updatePolicy;
    }

    /**
     * What to do when verification of an artifact checksum fails. Valid values are
     * {@code ignore},
     * {@code fail}
     * (default for Maven 4 and above) or
     * {@code warn}
     * (default for Maven 2 and 3)
     *
     * @return a {@code String}
     */
    public String getChecksumPolicy()
    {
        return this.checksumPolicy;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "enabled":
                    return enabledLocation;
                case "updatePolicy":
                    return updatePolicyLocation;
                case "checksumPolicy":
                    return checksumPolicyLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified enabled.
     *
     * @param enabled the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified enabled
     */
    @Nonnull
    public RepositoryPolicy withEnabled( String enabled )
    {
        return with().enabled( enabled ).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified updatePolicy.
     *
     * @param updatePolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified updatePolicy
     */
    @Nonnull
    public RepositoryPolicy withUpdatePolicy( String updatePolicy )
    {
        return with().updatePolicy( updatePolicy ).build();
    }
    /**
     * Creates a new {@code RepositoryPolicy} instance using the specified checksumPolicy.
     *
     * @param checksumPolicy the new {@code String} to use
     * @return a {@code RepositoryPolicy} with the specified checksumPolicy
     */
    @Nonnull
    public RepositoryPolicy withChecksumPolicy( String checksumPolicy )
    {
        return with().checksumPolicy( checksumPolicy ).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code RepositoryPolicy} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code RepositoryPolicy}
     */
    @Nonnull
    public static RepositoryPolicy newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryPolicy from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code RepositoryPolicy} builder instance using the specified object as a basis.
     *
     * @param from the {@code RepositoryPolicy} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( RepositoryPolicy from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create RepositoryPolicy instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        RepositoryPolicy base;
        String enabled;
        String updatePolicy;
        String checksumPolicy;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( RepositoryPolicy base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.enabled = base.enabled;
                this.updatePolicy = base.updatePolicy;
                this.checksumPolicy = base.checksumPolicy;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder enabled( String enabled )
        {
            this.enabled = enabled;
            return this;
        }

        @Nonnull
        public Builder updatePolicy( String updatePolicy )
        {
            this.updatePolicy = updatePolicy;
            return this;
        }

        @Nonnull
        public Builder checksumPolicy( String checksumPolicy )
        {
            this.checksumPolicy = checksumPolicy;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public RepositoryPolicy build()
        {
            if ( base != null
                    && ( enabled == null || enabled == base.enabled )
                    && ( updatePolicy == null || updatePolicy == base.updatePolicy )
                    && ( checksumPolicy == null || checksumPolicy == base.checksumPolicy )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation enabledLocation = null;
            InputLocation updatePolicyLocation = null;
            InputLocation checksumPolicyLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                enabledLocation = locations.remove( "enabled" );
                updatePolicyLocation = locations.remove( "updatePolicy" );
                checksumPolicyLocation = locations.remove( "checksumPolicy" );
            }
            return new RepositoryPolicy(
                enabled != null ? enabled : ( base != null ? base.enabled : null ),
                updatePolicy != null ? updatePolicy : ( base != null ? base.updatePolicy : null ),
                checksumPolicy != null ? checksumPolicy : ( base != null ? base.checksumPolicy : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                enabledLocation != null ? enabledLocation : ( base != null ? base.enabledLocation : null ),
                updatePolicyLocation != null ? updatePolicyLocation : ( base != null ? base.updatePolicyLocation : null ),
                checksumPolicyLocation != null ? checksumPolicyLocation : ( base != null ? base.checksumPolicyLocation : null )
            );
        }
    }


            
    public boolean isEnabled()
    {
        return ( getEnabled() != null ) ? Boolean.parseBoolean( getEnabled() ) : true;
    }

            
          
}
