// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Section for management of reports and their configuration.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Reporting
    implements Serializable, InputLocationTracker
{
    /**
     * If true, then the default reports are not included in the site generation.
     * This includes the reports in the "Project Info" menu. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     */
    final String excludeDefaults;
    /**
     * Where to store all of the generated reports. The default is
     * {@code ${project.build.directory}/site}.
     */
    final String outputDirectory;
    /**
     * The reporting plugins to use and their configuration.
     */
    final List<ReportPlugin> plugins;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field excludeDefaults. */
    final InputLocation excludeDefaultsLocation;
    /** Location of the xml element for the field outputDirectory. */
    final InputLocation outputDirectoryLocation;
    /** Location of the xml element for the field plugins. */
    final InputLocation pluginsLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Reporting(
        String excludeDefaults,
        String outputDirectory,
        Collection<ReportPlugin> plugins,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation excludeDefaultsLocation,
        InputLocation outputDirectoryLocation,
        InputLocation pluginsLocation
    )
    {
        this.excludeDefaults = excludeDefaults;
        this.outputDirectory = outputDirectory;
        this.plugins = ImmutableCollections.copy( plugins );
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.excludeDefaultsLocation = excludeDefaultsLocation;
        this.outputDirectoryLocation = outputDirectoryLocation;
        this.pluginsLocation = pluginsLocation;
    }

    /**
     * If true, then the default reports are not included in the site generation.
     * This includes the reports in the "Project Info" menu. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     *
     * @return a {@code String}
     */
    public String getExcludeDefaults()
    {
        return this.excludeDefaults;
    }

    /**
     * Where to store all of the generated reports. The default is
     * {@code ${project.build.directory}/site}.
     *
     * @return a {@code String}
     */
    public String getOutputDirectory()
    {
        return this.outputDirectory;
    }

    /**
     * The reporting plugins to use and their configuration.
     *
     * @return a {@code List<ReportPlugin>}
     */
    @Nonnull
    public List<ReportPlugin> getPlugins()
    {
        return this.plugins;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "excludeDefaults":
                    return excludeDefaultsLocation;
                case "outputDirectory":
                    return outputDirectoryLocation;
                case "plugins":
                    return pluginsLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Reporting} instance using the specified excludeDefaults.
     *
     * @param excludeDefaults the new {@code String} to use
     * @return a {@code Reporting} with the specified excludeDefaults
     */
    @Nonnull
    public Reporting withExcludeDefaults( String excludeDefaults )
    {
        return with().excludeDefaults( excludeDefaults ).build();
    }
    /**
     * Creates a new {@code Reporting} instance using the specified outputDirectory.
     *
     * @param outputDirectory the new {@code String} to use
     * @return a {@code Reporting} with the specified outputDirectory
     */
    @Nonnull
    public Reporting withOutputDirectory( String outputDirectory )
    {
        return with().outputDirectory( outputDirectory ).build();
    }
    /**
     * Creates a new {@code Reporting} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<ReportPlugin>} to use
     * @return a {@code Reporting} with the specified plugins
     */
    @Nonnull
    public Reporting withPlugins( Collection<ReportPlugin> plugins )
    {
        return with().plugins( plugins ).build();
    }

    /**
     * Creates a new {@code Reporting} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Reporting}
     */
    @Nonnull
    public static Reporting newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Reporting} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Reporting}
     */
    @Nonnull
    public static Reporting newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Reporting} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Reporting} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Reporting} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Reporting} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Reporting from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Reporting} builder instance using the specified object as a basis.
     *
     * @param from the {@code Reporting} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Reporting from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Reporting instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Reporting base;
        String excludeDefaults;
        String outputDirectory;
        Collection<ReportPlugin> plugins;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Reporting base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.excludeDefaults = base.excludeDefaults;
                this.outputDirectory = base.outputDirectory;
                this.plugins = base.plugins;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder excludeDefaults( String excludeDefaults )
        {
            this.excludeDefaults = excludeDefaults;
            return this;
        }

        @Nonnull
        public Builder outputDirectory( String outputDirectory )
        {
            this.outputDirectory = outputDirectory;
            return this;
        }

        @Nonnull
        public Builder plugins( Collection<ReportPlugin> plugins )
        {
            this.plugins = plugins;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Reporting build()
        {
            if ( base != null
                    && ( excludeDefaults == null || excludeDefaults == base.excludeDefaults )
                    && ( outputDirectory == null || outputDirectory == base.outputDirectory )
                    && ( plugins == null || plugins == base.plugins )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation excludeDefaultsLocation = null;
            InputLocation outputDirectoryLocation = null;
            InputLocation pluginsLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                excludeDefaultsLocation = locations.remove( "excludeDefaults" );
                outputDirectoryLocation = locations.remove( "outputDirectory" );
                pluginsLocation = locations.remove( "plugins" );
            }
            return new Reporting(
                excludeDefaults != null ? excludeDefaults : ( base != null ? base.excludeDefaults : null ),
                outputDirectory != null ? outputDirectory : ( base != null ? base.outputDirectory : null ),
                plugins != null ? plugins : ( base != null ? base.plugins : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                excludeDefaultsLocation != null ? excludeDefaultsLocation : ( base != null ? base.excludeDefaultsLocation : null ),
                outputDirectoryLocation != null ? outputDirectoryLocation : ( base != null ? base.outputDirectoryLocation : null ),
                pluginsLocation != null ? pluginsLocation : ( base != null ? base.pluginsLocation : null )
            );
        }
    }


            
    public boolean isExcludeDefaults()
    {
        return ( getExcludeDefaults() != null ) ? Boolean.parseBoolean( getExcludeDefaults() ) : false;
    }

            
          
}
