// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Contains the plugins informations for the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PluginContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The list of plugins to use.
     */
    final List<Plugin> plugins;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field plugins. */
    final InputLocation pluginsLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    PluginContainer(
        Collection<Plugin> plugins,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation pluginsLocation
    )
    {
        this.plugins = ImmutableCollections.copy( plugins );
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.pluginsLocation = pluginsLocation;
    }

    /**
     * The list of plugins to use.
     *
     * @return a {@code List<Plugin>}
     */
    @Nonnull
    public List<Plugin> getPlugins()
    {
        return this.plugins;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "plugins":
                    return pluginsLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code PluginContainer} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code PluginContainer} with the specified plugins
     */
    @Nonnull
    public PluginContainer withPlugins( Collection<Plugin> plugins )
    {
        return with().plugins( plugins ).build();
    }

    /**
     * Creates a new {@code PluginContainer} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PluginContainer}
     */
    @Nonnull
    public static PluginContainer newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code PluginContainer} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PluginContainer}
     */
    @Nonnull
    public static PluginContainer newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code PluginContainer} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code PluginContainer} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code PluginContainer} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code PluginContainer} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( PluginContainer from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code PluginContainer} builder instance using the specified object as a basis.
     *
     * @param from the {@code PluginContainer} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( PluginContainer from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create PluginContainer instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        PluginContainer base;
        Collection<Plugin> plugins;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( PluginContainer base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.plugins = base.plugins;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins( Collection<Plugin> plugins )
        {
            this.plugins = plugins;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public PluginContainer build()
        {
            if ( base != null
                    && ( plugins == null || plugins == base.plugins )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation pluginsLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                pluginsLocation = locations.remove( "plugins" );
            }
            return new PluginContainer(
                plugins != null ? plugins : ( base != null ? base.plugins : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                pluginsLocation != null ? pluginsLocation : ( base != null ? base.pluginsLocation : null )
            );
        }
    }


            
    Map<String, Plugin> pluginMap;

    /**
     * Reset the {@code pluginsMap} field to {@code null}
     */
    public synchronized void flushPluginMap()
    {
        this.pluginMap = null;
    }

    /**
     * @return a Map of plugins field with {@code Plugins#getKey()} as key
     * @see Plugin#getKey()
     */
    public synchronized Map<String, Plugin> getPluginsAsMap()
    {
        if ( pluginMap == null )
        {
            pluginMap = new java.util.LinkedHashMap<String, Plugin>();
            if ( getPlugins() != null )
            {
                for ( java.util.Iterator<Plugin> it = getPlugins().iterator(); it.hasNext(); )
                {
                    Plugin plugin = (Plugin) it.next();
                    pluginMap.put( plugin.getKey(), plugin );
                }
            }
        }

        return pluginMap;
    }
            
          

            
     @Override
     public String toString()
     {
         return "PluginContainer {}";
     }
            
          
}
