// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Information about the issue tracking (or bug tracking) system used to manage this
 * project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class IssueManagement
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the issue management system, e.g. Bugzilla
     */
    final String system;
    /**
     * URL for the issue management system used by the project.
     */
    final String url;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field system. */
    final InputLocation systemLocation;
    /** Location of the xml element for the field url. */
    final InputLocation urlLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    IssueManagement(
        String system,
        String url,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation systemLocation,
        InputLocation urlLocation
    )
    {
        this.system = system;
        this.url = url;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.systemLocation = systemLocation;
        this.urlLocation = urlLocation;
    }

    /**
     * The name of the issue management system, e.g. Bugzilla
     *
     * @return a {@code String}
     */
    public String getSystem()
    {
        return this.system;
    }

    /**
     * URL for the issue management system used by the project.
     *
     * @return a {@code String}
     */
    public String getUrl()
    {
        return this.url;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "system":
                    return systemLocation;
                case "url":
                    return urlLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code IssueManagement} instance using the specified system.
     *
     * @param system the new {@code String} to use
     * @return a {@code IssueManagement} with the specified system
     */
    @Nonnull
    public IssueManagement withSystem( String system )
    {
        return with().system( system ).build();
    }
    /**
     * Creates a new {@code IssueManagement} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code IssueManagement} with the specified url
     */
    @Nonnull
    public IssueManagement withUrl( String url )
    {
        return with().url( url ).build();
    }

    /**
     * Creates a new {@code IssueManagement} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code IssueManagement}
     */
    @Nonnull
    public static IssueManagement newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code IssueManagement} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code IssueManagement}
     */
    @Nonnull
    public static IssueManagement newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code IssueManagement} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code IssueManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code IssueManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code IssueManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( IssueManagement from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code IssueManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code IssueManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( IssueManagement from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create IssueManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        IssueManagement base;
        String system;
        String url;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( IssueManagement base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.system = base.system;
                this.url = base.url;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder system( String system )
        {
            this.system = system;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public IssueManagement build()
        {
            if ( base != null
                    && ( system == null || system == base.system )
                    && ( url == null || url == base.url )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation systemLocation = null;
            InputLocation urlLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                systemLocation = locations.remove( "system" );
                urlLocation = locations.remove( "url" );
            }
            return new IssueManagement(
                system != null ? system : ( base != null ? base.system : null ),
                url != null ? url : ( base != null ? base.url : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                systemLocation != null ? systemLocation : ( base != null ? base.systemLocation : null ),
                urlLocation != null ? urlLocation : ( base != null ? base.urlLocation : null )
            );
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "IssueManagement {system=" + getSystem() + ", url=" + getUrl() + "}";
    }
            
          
}
