// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Describes a build extension to utilise.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Extension
    implements Serializable, InputLocationTracker
{
    /**
     * The group ID of the extension's artifact.
     */
    final String groupId;
    /**
     * The artifact ID of the extension.
     */
    final String artifactId;
    /**
     * The version of the extension.
     */
    final String version;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field groupId. */
    final InputLocation groupIdLocation;
    /** Location of the xml element for the field artifactId. */
    final InputLocation artifactIdLocation;
    /** Location of the xml element for the field version. */
    final InputLocation versionLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Extension(
        String groupId,
        String artifactId,
        String version,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation groupIdLocation,
        InputLocation artifactIdLocation,
        InputLocation versionLocation
    )
    {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
    }

    /**
     * The group ID of the extension's artifact.
     *
     * @return a {@code String}
     */
    public String getGroupId()
    {
        return this.groupId;
    }

    /**
     * The artifact ID of the extension.
     *
     * @return a {@code String}
     */
    public String getArtifactId()
    {
        return this.artifactId;
    }

    /**
     * The version of the extension.
     *
     * @return a {@code String}
     */
    public String getVersion()
    {
        return this.version;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "groupId":
                    return groupIdLocation;
                case "artifactId":
                    return artifactIdLocation;
                case "version":
                    return versionLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Extension} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Extension} with the specified groupId
     */
    @Nonnull
    public Extension withGroupId( String groupId )
    {
        return with().groupId( groupId ).build();
    }
    /**
     * Creates a new {@code Extension} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Extension} with the specified artifactId
     */
    @Nonnull
    public Extension withArtifactId( String artifactId )
    {
        return with().artifactId( artifactId ).build();
    }
    /**
     * Creates a new {@code Extension} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Extension} with the specified version
     */
    @Nonnull
    public Extension withVersion( String version )
    {
        return with().version( version ).build();
    }

    /**
     * Creates a new {@code Extension} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Extension}
     */
    @Nonnull
    public static Extension newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Extension} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Extension}
     */
    @Nonnull
    public static Extension newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Extension} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Extension} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Extension} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Extension} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Extension from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Extension} builder instance using the specified object as a basis.
     *
     * @param from the {@code Extension} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Extension from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Extension instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        Extension base;
        String groupId;
        String artifactId;
        String version;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( Extension base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder groupId( String groupId )
        {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId( String artifactId )
        {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version( String version )
        {
            this.version = version;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Extension build()
        {
            if ( base != null
                    && ( groupId == null || groupId == base.groupId )
                    && ( artifactId == null || artifactId == base.artifactId )
                    && ( version == null || version == base.version )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                groupIdLocation = locations.remove( "groupId" );
                artifactIdLocation = locations.remove( "artifactId" );
                versionLocation = locations.remove( "version" );
            }
            return new Extension(
                groupId != null ? groupId : ( base != null ? base.groupId : null ),
                artifactId != null ? artifactId : ( base != null ? base.artifactId : null ),
                version != null ? version : ( base != null ? base.version : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                groupIdLocation != null ? groupIdLocation : ( base != null ? base.groupIdLocation : null ),
                artifactIdLocation != null ? artifactIdLocation : ( base != null ? base.artifactIdLocation : null ),
                versionLocation != null ? versionLocation : ( base != null ? base.versionLocation : null )
            );
        }
    }


            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }

        if ( !( o instanceof Extension ) )
        {
            return false;
        }

        Extension e = (Extension) o;

        if ( !equal( e.getArtifactId(), getArtifactId() ) )
        {
            return false;
        }
        else if ( !equal( e.getGroupId(), getGroupId() ) )
        {
            return false;
        }
        else if ( !equal( e.getVersion(), getVersion() ) )
        {
            return false;
        }
        return true;
    }

    private static <T> boolean equal( T obj1, T obj2 )
    {
        return ( obj1 != null ) ? obj1.equals( obj2 ) : obj2 == null;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode()
    {
        int result = 17;
        result = 37 * result + ( getArtifactId() != null ? getArtifactId().hashCode() : 0 );
        result = 37 * result + ( getGroupId() != null ? getGroupId().hashCode() : 0 );
        result = 37 * result + ( getVersion() != null ? getVersion().hashCode() : 0 );
        return result;
    }
            
          
}
