// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This elements describes all that pertains to distribution for a project. It is
 * primarily used for deployment of artifacts and the site produced by the build.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class DistributionManagement
    implements Serializable, InputLocationTracker
{
    /**
     * Information needed to deploy the artifacts generated by the project to a
     * remote repository.
     */
    final DeploymentRepository repository;
    /**
     * Where to deploy snapshots of artifacts to. If not given, it defaults to the
     * {@code repository} element.
     */
    final DeploymentRepository snapshotRepository;
    /**
     * Information needed for deploying the web site of the project.
     */
    final Site site;
    /**
     * The URL of the project's download page. If not given users will be
     * referred to the homepage given by {@code url}.
     * This is given to assist in locating artifacts that are not in the repository due to
     * licensing restrictions.
     */
    final String downloadUrl;
    /**
     * Relocation information of the artifact if it has been moved to a new group ID
     * and/or artifact ID.
     */
    final Relocation relocation;
    /**
     * Gives the status of this artifact in the remote repository.
     * This must not be set in your local project, as it is updated by
     * tools placing it in the reposiory. Valid values are: {@code none} (default),
     * {@code converted} (repository manager converted this from an Maven 1 POM),
     * {@code partner}
     * (directly synced from a partner Maven 2 repository), {@code deployed} (was deployed from a Maven 2
     * instance), {@code verified} (has been hand verified as correct and final).
     */
    final String status;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field repository. */
    final InputLocation repositoryLocation;
    /** Location of the xml element for the field snapshotRepository. */
    final InputLocation snapshotRepositoryLocation;
    /** Location of the xml element for the field site. */
    final InputLocation siteLocation;
    /** Location of the xml element for the field downloadUrl. */
    final InputLocation downloadUrlLocation;
    /** Location of the xml element for the field relocation. */
    final InputLocation relocationLocation;
    /** Location of the xml element for the field status. */
    final InputLocation statusLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    DistributionManagement(
        DeploymentRepository repository,
        DeploymentRepository snapshotRepository,
        Site site,
        String downloadUrl,
        Relocation relocation,
        String status,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation repositoryLocation,
        InputLocation snapshotRepositoryLocation,
        InputLocation siteLocation,
        InputLocation downloadUrlLocation,
        InputLocation relocationLocation,
        InputLocation statusLocation
    )
    {
        this.repository = repository;
        this.snapshotRepository = snapshotRepository;
        this.site = site;
        this.downloadUrl = downloadUrl;
        this.relocation = relocation;
        this.status = status;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.repositoryLocation = repositoryLocation;
        this.snapshotRepositoryLocation = snapshotRepositoryLocation;
        this.siteLocation = siteLocation;
        this.downloadUrlLocation = downloadUrlLocation;
        this.relocationLocation = relocationLocation;
        this.statusLocation = statusLocation;
    }

    /**
     * Information needed to deploy the artifacts generated by the project to a
     * remote repository.
     *
     * @return a {@code DeploymentRepository}
     */
    public DeploymentRepository getRepository()
    {
        return this.repository;
    }

    /**
     * Where to deploy snapshots of artifacts to. If not given, it defaults to the
     * {@code repository} element.
     *
     * @return a {@code DeploymentRepository}
     */
    public DeploymentRepository getSnapshotRepository()
    {
        return this.snapshotRepository;
    }

    /**
     * Information needed for deploying the web site of the project.
     *
     * @return a {@code Site}
     */
    public Site getSite()
    {
        return this.site;
    }

    /**
     * The URL of the project's download page. If not given users will be
     * referred to the homepage given by {@code url}.
     * This is given to assist in locating artifacts that are not in the repository due to
     * licensing restrictions.
     *
     * @return a {@code String}
     */
    public String getDownloadUrl()
    {
        return this.downloadUrl;
    }

    /**
     * Relocation information of the artifact if it has been moved to a new group ID
     * and/or artifact ID.
     *
     * @return a {@code Relocation}
     */
    public Relocation getRelocation()
    {
        return this.relocation;
    }

    /**
     * Gives the status of this artifact in the remote repository.
     * This must not be set in your local project, as it is updated by
     * tools placing it in the reposiory. Valid values are: {@code none} (default),
     * {@code converted} (repository manager converted this from an Maven 1 POM),
     * {@code partner}
     * (directly synced from a partner Maven 2 repository), {@code deployed} (was deployed from a Maven 2
     * instance), {@code verified} (has been hand verified as correct and final).
     *
     * @return a {@code String}
     */
    public String getStatus()
    {
        return this.status;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "repository":
                    return repositoryLocation;
                case "snapshotRepository":
                    return snapshotRepositoryLocation;
                case "site":
                    return siteLocation;
                case "downloadUrl":
                    return downloadUrlLocation;
                case "relocation":
                    return relocationLocation;
                case "status":
                    return statusLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code DistributionManagement} instance using the specified repository.
     *
     * @param repository the new {@code DeploymentRepository} to use
     * @return a {@code DistributionManagement} with the specified repository
     */
    @Nonnull
    public DistributionManagement withRepository( DeploymentRepository repository )
    {
        return with().repository( repository ).build();
    }
    /**
     * Creates a new {@code DistributionManagement} instance using the specified snapshotRepository.
     *
     * @param snapshotRepository the new {@code DeploymentRepository} to use
     * @return a {@code DistributionManagement} with the specified snapshotRepository
     */
    @Nonnull
    public DistributionManagement withSnapshotRepository( DeploymentRepository snapshotRepository )
    {
        return with().snapshotRepository( snapshotRepository ).build();
    }
    /**
     * Creates a new {@code DistributionManagement} instance using the specified site.
     *
     * @param site the new {@code Site} to use
     * @return a {@code DistributionManagement} with the specified site
     */
    @Nonnull
    public DistributionManagement withSite( Site site )
    {
        return with().site( site ).build();
    }
    /**
     * Creates a new {@code DistributionManagement} instance using the specified downloadUrl.
     *
     * @param downloadUrl the new {@code String} to use
     * @return a {@code DistributionManagement} with the specified downloadUrl
     */
    @Nonnull
    public DistributionManagement withDownloadUrl( String downloadUrl )
    {
        return with().downloadUrl( downloadUrl ).build();
    }
    /**
     * Creates a new {@code DistributionManagement} instance using the specified relocation.
     *
     * @param relocation the new {@code Relocation} to use
     * @return a {@code DistributionManagement} with the specified relocation
     */
    @Nonnull
    public DistributionManagement withRelocation( Relocation relocation )
    {
        return with().relocation( relocation ).build();
    }
    /**
     * Creates a new {@code DistributionManagement} instance using the specified status.
     *
     * @param status the new {@code String} to use
     * @return a {@code DistributionManagement} with the specified status
     */
    @Nonnull
    public DistributionManagement withStatus( String status )
    {
        return with().status( status ).build();
    }

    /**
     * Creates a new {@code DistributionManagement} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code DistributionManagement}
     */
    @Nonnull
    public static DistributionManagement newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code DistributionManagement} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code DistributionManagement}
     */
    @Nonnull
    public static DistributionManagement newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code DistributionManagement} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code DistributionManagement} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code DistributionManagement} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code DistributionManagement} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( DistributionManagement from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code DistributionManagement} builder instance using the specified object as a basis.
     *
     * @param from the {@code DistributionManagement} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( DistributionManagement from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create DistributionManagement instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        DistributionManagement base;
        DeploymentRepository repository;
        DeploymentRepository snapshotRepository;
        Site site;
        String downloadUrl;
        Relocation relocation;
        String status;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( DistributionManagement base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.repository = base.repository;
                this.snapshotRepository = base.snapshotRepository;
                this.site = base.site;
                this.downloadUrl = base.downloadUrl;
                this.relocation = base.relocation;
                this.status = base.status;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder repository( DeploymentRepository repository )
        {
            this.repository = repository;
            return this;
        }

        @Nonnull
        public Builder snapshotRepository( DeploymentRepository snapshotRepository )
        {
            this.snapshotRepository = snapshotRepository;
            return this;
        }

        @Nonnull
        public Builder site( Site site )
        {
            this.site = site;
            return this;
        }

        @Nonnull
        public Builder downloadUrl( String downloadUrl )
        {
            this.downloadUrl = downloadUrl;
            return this;
        }

        @Nonnull
        public Builder relocation( Relocation relocation )
        {
            this.relocation = relocation;
            return this;
        }

        @Nonnull
        public Builder status( String status )
        {
            this.status = status;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public DistributionManagement build()
        {
            if ( base != null
                    && ( repository == null || repository == base.repository )
                    && ( snapshotRepository == null || snapshotRepository == base.snapshotRepository )
                    && ( site == null || site == base.site )
                    && ( downloadUrl == null || downloadUrl == base.downloadUrl )
                    && ( relocation == null || relocation == base.relocation )
                    && ( status == null || status == base.status )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation repositoryLocation = null;
            InputLocation snapshotRepositoryLocation = null;
            InputLocation siteLocation = null;
            InputLocation downloadUrlLocation = null;
            InputLocation relocationLocation = null;
            InputLocation statusLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                repositoryLocation = locations.remove( "repository" );
                snapshotRepositoryLocation = locations.remove( "snapshotRepository" );
                siteLocation = locations.remove( "site" );
                downloadUrlLocation = locations.remove( "downloadUrl" );
                relocationLocation = locations.remove( "relocation" );
                statusLocation = locations.remove( "status" );
            }
            return new DistributionManagement(
                repository != null ? repository : ( base != null ? base.repository : null ),
                snapshotRepository != null ? snapshotRepository : ( base != null ? base.snapshotRepository : null ),
                site != null ? site : ( base != null ? base.site : null ),
                downloadUrl != null ? downloadUrl : ( base != null ? base.downloadUrl : null ),
                relocation != null ? relocation : ( base != null ? base.relocation : null ),
                status != null ? status : ( base != null ? base.status : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                repositoryLocation != null ? repositoryLocation : ( base != null ? base.repositoryLocation : null ),
                snapshotRepositoryLocation != null ? snapshotRepositoryLocation : ( base != null ? base.snapshotRepositoryLocation : null ),
                siteLocation != null ? siteLocation : ( base != null ? base.siteLocation : null ),
                downloadUrlLocation != null ? downloadUrlLocation : ( base != null ? base.downloadUrlLocation : null ),
                relocationLocation != null ? relocationLocation : ( base != null ? base.relocationLocation : null ),
                statusLocation != null ? statusLocation : ( base != null ? base.statusLocation : null )
            );
        }
    }

}
