// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Deployment repository contains the information needed for deploying to the remote
 * repository, which adds uniqueVersion property to usual repositories for download.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class DeploymentRepository
    extends Repository
    implements Serializable, InputLocationTracker
{
    /**
     * Whether to assign snapshots a unique version comprised of the timestamp and
     * build number, or to use the same version each time
     */
    final boolean uniqueVersion;
    /** Location of the xml element for the field uniqueVersion. */
    final InputLocation uniqueVersionLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    DeploymentRepository(
        String id,
        String name,
        String url,
        String layout,
        RepositoryPolicy releases,
        RepositoryPolicy snapshots,
        boolean uniqueVersion,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation idLocation,
        InputLocation nameLocation,
        InputLocation urlLocation,
        InputLocation layoutLocation,
        InputLocation releasesLocation,
        InputLocation snapshotsLocation,
        InputLocation uniqueVersionLocation
    )
    {
        super(
            id,
            name,
            url,
            layout,
            releases,
            snapshots,
            locations,
            location,
            idLocation,
            nameLocation,
            urlLocation,
            layoutLocation,
            releasesLocation,
            snapshotsLocation
        );
        this.uniqueVersion = uniqueVersion;
        this.uniqueVersionLocation = uniqueVersionLocation;
    }

    @Override
    public boolean equals( Object o )
    {
        if ( this == o )
        {
            return true;
        }
        if ( o == null || !( o instanceof DeploymentRepository ) )
        {
            return false;
        }
        DeploymentRepository that = ( DeploymentRepository ) o;
        return Objects.equals( this.id, that.id );
    }

    @Override
    public int hashCode()
    {
        return Objects.hash( id );
    }

    /**
     * Whether to assign snapshots a unique version comprised of the timestamp and
     * build number, or to use the same version each time
     *
     * @return a {@code boolean}
     */
    public boolean isUniqueVersion()
    {
        return this.uniqueVersion;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "uniqueVersion":
                    return uniqueVersionLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified id
     */
    @Nonnull
    public DeploymentRepository withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified name
     */
    @Nonnull
    public DeploymentRepository withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified url.
     *
     * @param url the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified url
     */
    @Nonnull
    public DeploymentRepository withUrl( String url )
    {
        return with().url( url ).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified layout.
     *
     * @param layout the new {@code String} to use
     * @return a {@code DeploymentRepository} with the specified layout
     */
    @Nonnull
    public DeploymentRepository withLayout( String layout )
    {
        return with().layout( layout ).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified releases.
     *
     * @param releases the new {@code RepositoryPolicy} to use
     * @return a {@code DeploymentRepository} with the specified releases
     */
    @Nonnull
    public DeploymentRepository withReleases( RepositoryPolicy releases )
    {
        return with().releases( releases ).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified snapshots.
     *
     * @param snapshots the new {@code RepositoryPolicy} to use
     * @return a {@code DeploymentRepository} with the specified snapshots
     */
    @Nonnull
    public DeploymentRepository withSnapshots( RepositoryPolicy snapshots )
    {
        return with().snapshots( snapshots ).build();
    }
    /**
     * Creates a new {@code DeploymentRepository} instance using the specified uniqueVersion.
     *
     * @param uniqueVersion the new {@code boolean} to use
     * @return a {@code DeploymentRepository} with the specified uniqueVersion
     */
    @Nonnull
    public DeploymentRepository withUniqueVersion( boolean uniqueVersion )
    {
        return with().uniqueVersion( uniqueVersion ).build();
    }

    /**
     * Creates a new {@code DeploymentRepository} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code DeploymentRepository}
     */
    @Nonnull
    public static DeploymentRepository newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code DeploymentRepository} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code DeploymentRepository}
     */
    @Nonnull
    public static DeploymentRepository newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code DeploymentRepository} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( DeploymentRepository from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code DeploymentRepository} builder instance using the specified object as a basis.
     *
     * @param from the {@code DeploymentRepository} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( DeploymentRepository from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create DeploymentRepository instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends Repository.Builder
    {
        DeploymentRepository base;
        Boolean uniqueVersion;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.uniqueVersion = true;
            }
        }

        Builder( DeploymentRepository base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.uniqueVersion = base.uniqueVersion;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url( String url )
        {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder layout( String layout )
        {
            this.layout = layout;
            return this;
        }

        @Nonnull
        public Builder releases( RepositoryPolicy releases )
        {
            this.releases = releases;
            return this;
        }

        @Nonnull
        public Builder snapshots( RepositoryPolicy snapshots )
        {
            this.snapshots = snapshots;
            return this;
        }

        @Nonnull
        public Builder uniqueVersion( boolean uniqueVersion )
        {
            this.uniqueVersion = uniqueVersion;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public DeploymentRepository build()
        {
            if ( base != null
                    && ( id == null || id == base.id )
                    && ( name == null || name == base.name )
                    && ( url == null || url == base.url )
                    && ( layout == null || layout == base.layout )
                    && ( releases == null || releases == base.releases )
                    && ( snapshots == null || snapshots == base.snapshots )
                    && ( uniqueVersion == null || uniqueVersion == base.uniqueVersion )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation idLocation = null;
            InputLocation nameLocation = null;
            InputLocation urlLocation = null;
            InputLocation layoutLocation = null;
            InputLocation releasesLocation = null;
            InputLocation snapshotsLocation = null;
            InputLocation uniqueVersionLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                idLocation = locations.remove( "id" );
                nameLocation = locations.remove( "name" );
                urlLocation = locations.remove( "url" );
                layoutLocation = locations.remove( "layout" );
                releasesLocation = locations.remove( "releases" );
                snapshotsLocation = locations.remove( "snapshots" );
                uniqueVersionLocation = locations.remove( "uniqueVersion" );
            }
            return new DeploymentRepository(
                id != null ? id : ( base != null ? base.id : null ),
                name != null ? name : ( base != null ? base.name : null ),
                url != null ? url : ( base != null ? base.url : null ),
                layout != null ? layout : ( base != null ? base.layout : null ),
                releases != null ? releases : ( base != null ? base.releases : null ),
                snapshots != null ? snapshots : ( base != null ? base.snapshots : null ),
                uniqueVersion != null ? uniqueVersion : ( base != null ? base.uniqueVersion : true ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                idLocation != null ? idLocation : ( base != null ? base.idLocation : null ),
                nameLocation != null ? nameLocation : ( base != null ? base.nameLocation : null ),
                urlLocation != null ? urlLocation : ( base != null ? base.urlLocation : null ),
                layoutLocation != null ? layoutLocation : ( base != null ? base.layoutLocation : null ),
                releasesLocation != null ? releasesLocation : ( base != null ? base.releasesLocation : null ),
                snapshotsLocation != null ? snapshotsLocation : ( base != null ? base.snapshotsLocation : null ),
                uniqueVersionLocation != null ? uniqueVersionLocation : ( base != null ? base.uniqueVersionLocation : null )
            );
        }
    }

}
