// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This is the property specification used to activate a profile. If the value field
 * is empty, then the existence of the named property will activate the profile, otherwise it
 * does a case-sensitive match against the property value as well.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ActivationProperty
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the property to be used to activate a profile.
     */
    final String name;
    /**
     * The value of the property required to activate a profile.
     */
    final String value;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field name. */
    final InputLocation nameLocation;
    /** Location of the xml element for the field value. */
    final InputLocation valueLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ActivationProperty(
        String name,
        String value,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation nameLocation,
        InputLocation valueLocation
    )
    {
        this.name = name;
        this.value = value;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.nameLocation = nameLocation;
        this.valueLocation = valueLocation;
    }

    /**
     * The name of the property to be used to activate a profile.
     *
     * @return a {@code String}
     */
    public String getName()
    {
        return this.name;
    }

    /**
     * The value of the property required to activate a profile.
     *
     * @return a {@code String}
     */
    public String getValue()
    {
        return this.value;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "name":
                    return nameLocation;
                case "value":
                    return valueLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ActivationProperty} instance using the specified name.
     *
     * @param name the new {@code String} to use
     * @return a {@code ActivationProperty} with the specified name
     */
    @Nonnull
    public ActivationProperty withName( String name )
    {
        return with().name( name ).build();
    }
    /**
     * Creates a new {@code ActivationProperty} instance using the specified value.
     *
     * @param value the new {@code String} to use
     * @return a {@code ActivationProperty} with the specified value
     */
    @Nonnull
    public ActivationProperty withValue( String value )
    {
        return with().value( value ).build();
    }

    /**
     * Creates a new {@code ActivationProperty} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ActivationProperty}
     */
    @Nonnull
    public static ActivationProperty newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ActivationProperty} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ActivationProperty}
     */
    @Nonnull
    public static ActivationProperty newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ActivationProperty} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ActivationProperty} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ActivationProperty} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ActivationProperty} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ActivationProperty from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ActivationProperty} builder instance using the specified object as a basis.
     *
     * @param from the {@code ActivationProperty} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ActivationProperty from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ActivationProperty instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ActivationProperty base;
        String name;
        String value;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( ActivationProperty base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.name = base.name;
                this.value = base.value;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder name( String name )
        {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder value( String value )
        {
            this.value = value;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ActivationProperty build()
        {
            if ( base != null
                    && ( name == null || name == base.name )
                    && ( value == null || value == base.value )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation nameLocation = null;
            InputLocation valueLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                nameLocation = locations.remove( "name" );
                valueLocation = locations.remove( "value" );
            }
            return new ActivationProperty(
                name != null ? name : ( base != null ? base.name : null ),
                value != null ? value : ( base != null ? base.value : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                nameLocation != null ? nameLocation : ( base != null ? base.nameLocation : null ),
                valueLocation != null ? valueLocation : ( base != null ? base.valueLocation : null )
            );
        }
    }

}
