// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * This is the file specification used to activate the profile. The {@code missing} value
 * is the location of a file that needs to exist, and if it doesn't, the profile will be
 * activated. On the other hand, {@code exists} will test for the existence of the file and if it is
 * there, the profile will be activated.<br>
 * Variable interpolation for these file specifications is limited to {@code ${basedir}},
 * system properties and user properties.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ActivationFile
    implements Serializable, InputLocationTracker
{
    /**
     * The name of the file that must be missing to activate the
     * profile.
     */
    final String missing;
    /**
     * The name of the file that must exist to activate the profile.
     */
    final String exists;
    /** Location of the xml element for this object. */
    final InputLocation location;
    /** Location of the xml element for the field missing. */
    final InputLocation missingLocation;
    /** Location of the xml element for the field exists. */
    final InputLocation existsLocation;
    /** Other locations */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ActivationFile(
        String missing,
        String exists,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation missingLocation,
        InputLocation existsLocation
    )
    {
        this.missing = missing;
        this.exists = exists;
        this.locations = ImmutableCollections.copy( locations );
        this.location = location;
        this.missingLocation = missingLocation;
        this.existsLocation = existsLocation;
    }

    /**
     * The name of the file that must be missing to activate the
     * profile.
     *
     * @return a {@code String}
     */
    public String getMissing()
    {
        return this.missing;
    }

    /**
     * The name of the file that must exist to activate the profile.
     *
     * @return a {@code String}
     */
    public String getExists()
    {
        return this.exists;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "":
                    return location;
                case "missing":
                    return missingLocation;
                case "exists":
                    return existsLocation;
            }
        }
        return locations != null ? locations.get( key ) : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ActivationFile} instance using the specified missing.
     *
     * @param missing the new {@code String} to use
     * @return a {@code ActivationFile} with the specified missing
     */
    @Nonnull
    public ActivationFile withMissing( String missing )
    {
        return with().missing( missing ).build();
    }
    /**
     * Creates a new {@code ActivationFile} instance using the specified exists.
     *
     * @param exists the new {@code String} to use
     * @return a {@code ActivationFile} with the specified exists
     */
    @Nonnull
    public ActivationFile withExists( String exists )
    {
        return with().exists( exists ).build();
    }

    /**
     * Creates a new {@code ActivationFile} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ActivationFile}
     */
    @Nonnull
    public static ActivationFile newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ActivationFile} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ActivationFile}
     */
    @Nonnull
    public static ActivationFile newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ActivationFile} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ActivationFile} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ActivationFile} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ActivationFile} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ActivationFile from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ActivationFile} builder instance using the specified object as a basis.
     *
     * @param from the {@code ActivationFile} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ActivationFile from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ActivationFile instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
    {
        ActivationFile base;
        String missing;
        String exists;
        Map<Object, InputLocation> locations;

        Builder( boolean withDefaults )
        {
            if ( withDefaults )
            {
            }
        }

        Builder( ActivationFile base, boolean forceCopy )
        {
            if ( forceCopy )
            {
                this.missing = base.missing;
                this.exists = base.exists;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder missing( String missing )
        {
            this.missing = missing;
            return this;
        }

        @Nonnull
        public Builder exists( String exists )
        {
            this.exists = exists;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ActivationFile build()
        {
            if ( base != null
                    && ( missing == null || missing == base.missing )
                    && ( exists == null || exists == base.exists )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation missingLocation = null;
            InputLocation existsLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                missingLocation = locations.remove( "missing" );
                existsLocation = locations.remove( "exists" );
            }
            return new ActivationFile(
                missing != null ? missing : ( base != null ? base.missing : null ),
                exists != null ? exists : ( base != null ? base.exists : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                missingLocation != null ? missingLocation : ( base != null ? base.missingLocation : null ),
                existsLocation != null ? existsLocation : ( base != null ? base.existsLocation : null )
            );
        }
    }

}
