/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.util.Collection;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.services.BaseRequest;

@Experimental
@Immutable
public interface ArtifactDeployerRequest {
    @Nonnull
    public Session getSession();

    @Nonnull
    public RemoteRepository getRepository();

    @Nonnull
    public Collection<Artifact> getArtifacts();

    public int getRetryFailedDeploymentCount();

    @Nonnull
    public static ArtifactDeployerRequestBuilder builder() {
        return new ArtifactDeployerRequestBuilder();
    }

    @Nonnull
    public static ArtifactDeployerRequest build(@Nonnull Session session, @Nonnull RemoteRepository repository, @Nonnull Collection<Artifact> artifacts) {
        return ArtifactDeployerRequest.builder().session(BaseRequest.nonNull(session, "session cannot be null")).repository(BaseRequest.nonNull(repository, "repository cannot be null")).artifacts(BaseRequest.nonNull(artifacts, "artifacts cannot be null")).build();
    }

    public static class ArtifactDeployerRequestBuilder {
        Session session;
        RemoteRepository repository;
        Collection<Artifact> artifacts;
        int retryFailedDeploymentCount;

        ArtifactDeployerRequestBuilder() {
        }

        @Nonnull
        public ArtifactDeployerRequestBuilder session(Session session) {
            this.session = session;
            return this;
        }

        @Nonnull
        public ArtifactDeployerRequestBuilder repository(RemoteRepository repository) {
            this.repository = repository;
            return this;
        }

        public ArtifactDeployerRequestBuilder artifacts(Collection<Artifact> artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public ArtifactDeployerRequestBuilder retryFailedDeploymentCount(int retryFailedDeploymentCount) {
            this.retryFailedDeploymentCount = retryFailedDeploymentCount;
            return this;
        }

        @Nonnull
        public ArtifactDeployerRequest build() {
            return new DefaultArtifactDeployerRequest(this.session, this.repository, this.artifacts, this.retryFailedDeploymentCount);
        }

        private static class DefaultArtifactDeployerRequest
        extends BaseRequest
        implements ArtifactDeployerRequest {
            private final RemoteRepository repository;
            private final Collection<Artifact> artifacts;
            private final int retryFailedDeploymentCount;

            DefaultArtifactDeployerRequest(@Nonnull Session session, @Nonnull RemoteRepository repository, @Nonnull Collection<Artifact> artifacts, int retryFailedDeploymentCount) {
                super(session);
                this.repository = DefaultArtifactDeployerRequest.nonNull(repository, "repository cannot be null");
                this.artifacts = DefaultArtifactDeployerRequest.unmodifiable(DefaultArtifactDeployerRequest.nonNull(artifacts, "artifacts cannot be null"));
                this.retryFailedDeploymentCount = retryFailedDeploymentCount;
            }

            @Override
            @Nonnull
            public RemoteRepository getRepository() {
                return this.repository;
            }

            @Override
            @Nonnull
            public Collection<Artifact> getArtifacts() {
                return this.artifacts;
            }

            @Override
            public int getRetryFailedDeploymentCount() {
                return this.retryFailedDeploymentCount;
            }
        }
    }
}

