/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extensions.enforcer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.inject.Named;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Named(value="enforcer")
public class EnforceExtension
extends AbstractMavenLifecycleParticipant {
    private static final String ENFORCER_EXTENSION_XML = ".mvn/enforcer-extension.xml";
    private static final String POM_PROPERTIES = "/META-INF/maven/org.apache.maven.extensions/maven-enforcer-extension/pom.properties";

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        Xpp3Dom configuration;
        block27: {
            Path config = Paths.get(session.getExecutionRootDirectory(), ENFORCER_EXTENSION_XML);
            if (Files.isRegularFile(config, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(config, StandardCharsets.UTF_8);){
                    configuration = Xpp3DomBuilder.build((Reader)reader);
                    break block27;
                }
                catch (IOException | XmlPullParserException e) {
                    throw new MavenExecutionException("Failed to read .mvn/enforcer-extension.xml", e);
                }
            }
            return;
        }
        ArrayList<PluginExecution> executions = null;
        Xpp3Dom executionsDom = configuration.getChild("executions");
        if (executionsDom != null) {
            executions = new ArrayList<PluginExecution>();
            for (Xpp3Dom executionDom : executionsDom.getChildren("execution")) {
                executions.add(EnforceExtension.getPluginExecution(executionDom));
            }
        }
        if (executions == null) {
            return;
        }
        for (MavenProject project : session.getProjects()) {
            Plugin enforcerPlugin = null;
            for (Plugin plugin : project.getBuildPlugins()) {
                if (!"maven-enforcer-plugin".equals(plugin.getArtifactId()) || !"org.apache.maven.plugins".equals(plugin.getGroupId())) continue;
                enforcerPlugin = plugin;
            }
            if (enforcerPlugin == null) {
                enforcerPlugin = new Plugin();
                enforcerPlugin.setGroupId("org.apache.maven.plugins");
                enforcerPlugin.setArtifactId("maven-enforcer-plugin");
                try (InputStream is2 = EnforceExtension.class.getResourceAsStream(POM_PROPERTIES);){
                    Properties properties = new Properties();
                    properties.load(is2);
                    enforcerPlugin.setVersion(properties.getProperty("version"));
                }
                catch (IOException is2) {
                    // empty catch block
                }
                if (project.getBuildPlugins().isEmpty()) {
                    Build build = project.getBuild();
                    if (build == null) {
                        build = new Build();
                        project.setBuild(build);
                    }
                    build.setPlugins(Collections.singletonList(enforcerPlugin));
                } else {
                    ArrayList<Plugin> buildPlugins = new ArrayList<Plugin>(project.getBuildPlugins());
                    buildPlugins.add(enforcerPlugin);
                    project.getBuild().setPlugins(buildPlugins);
                }
            }
            for (PluginExecution pe : executions) {
                enforcerPlugin.addExecution(pe);
            }
        }
    }

    private static PluginExecution getPluginExecution(Xpp3Dom execution) {
        PluginExecution pluginExecution = new PluginExecution();
        pluginExecution.setId(EnforceExtension.get(execution, "id", "default-extension"));
        pluginExecution.addGoal("enforce");
        pluginExecution.setPhase(EnforceExtension.get(execution, "phase", "validate"));
        pluginExecution.setConfiguration((Object)execution.getChild("configuration"));
        return pluginExecution;
    }

    private static String get(Xpp3Dom elm, String name, String defaultValue) {
        if (elm == null || elm.getChild(name) == null) {
            return defaultValue;
        }
        return elm.getChild(name).getValue();
    }
}

