// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.0.0,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.buildcache.xml.config.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.buildcache.xml.config.AttachedOutputs;
import org.apache.maven.buildcache.xml.config.CacheConfig;
import org.apache.maven.buildcache.xml.config.Configuration;
import org.apache.maven.buildcache.xml.config.CoordinatesBase;
import org.apache.maven.buildcache.xml.config.DirScanConfig;
import org.apache.maven.buildcache.xml.config.Discovery;
import org.apache.maven.buildcache.xml.config.EffectivePom;
import org.apache.maven.buildcache.xml.config.Exclude;
import org.apache.maven.buildcache.xml.config.Executables;
import org.apache.maven.buildcache.xml.config.ExecutionConfigurationScan;
import org.apache.maven.buildcache.xml.config.ExecutionControl;
import org.apache.maven.buildcache.xml.config.ExecutionIdsList;
import org.apache.maven.buildcache.xml.config.GoalId;
import org.apache.maven.buildcache.xml.config.GoalReconciliation;
import org.apache.maven.buildcache.xml.config.GoalsList;
import org.apache.maven.buildcache.xml.config.Include;
import org.apache.maven.buildcache.xml.config.Input;
import org.apache.maven.buildcache.xml.config.Local;
import org.apache.maven.buildcache.xml.config.MultiModule;
import org.apache.maven.buildcache.xml.config.Output;
import org.apache.maven.buildcache.xml.config.OutputExclude;
import org.apache.maven.buildcache.xml.config.PathSet;
import org.apache.maven.buildcache.xml.config.PluginConfigurationScan;
import org.apache.maven.buildcache.xml.config.PluginSet;
import org.apache.maven.buildcache.xml.config.ProjectVersioning;
import org.apache.maven.buildcache.xml.config.PropertyName;
import org.apache.maven.buildcache.xml.config.Reconcile;
import org.apache.maven.buildcache.xml.config.Remote;
import org.apache.maven.buildcache.xml.config.TagExclude;
import org.apache.maven.buildcache.xml.config.TagScanConfig;
import org.apache.maven.buildcache.xml.config.TrackedProperty;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class BuildCacheConfigXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class BuildCacheConfigXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public BuildCacheConfigXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.apache.maven.buildcache.xml.config.io.xpp3.BuildCacheConfigXpp3Reader()

    public BuildCacheConfigXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.apache.maven.buildcache.xml.config.io.xpp3.BuildCacheConfigXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CacheConfig
     */
    public CacheConfig read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- CacheConfig read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CacheConfig
     */
    public CacheConfig read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- CacheConfig read( Reader )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CacheConfig
     */
    public CacheConfig read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- CacheConfig read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CacheConfig
     */
    public CacheConfig read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- CacheConfig read( InputStream )

    /**
     * Method parseAttachedOutputs.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return AttachedOutputs
     */
    private AttachedOutputs parseAttachedOutputs( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        AttachedOutputs attachedOutputs = new AttachedOutputs();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "dirNames", null, parsed ) )
            {
                java.util.List<String> dirNames = new java.util.ArrayList<String>();
                attachedOutputs.setDirNames( dirNames );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "dirName".equals( parser.getName() ) )
                    {
                        dirNames.add( interpolatedTrimmed( parser.nextText(), "dirNames" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return attachedOutputs;
    } //-- AttachedOutputs parseAttachedOutputs( XmlPullParser, boolean )

    /**
     * Method parseCacheConfig.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CacheConfig
     */
    private CacheConfig parseCacheConfig( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        CacheConfig cacheConfig = new CacheConfig();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "configuration", null, parsed ) )
            {
                cacheConfig.setConfiguration( parseConfiguration( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "input", null, parsed ) )
            {
                cacheConfig.setInput( parseInput( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "output", null, parsed ) )
            {
                cacheConfig.setOutput( parseOutput( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "executionControl", null, parsed ) )
            {
                cacheConfig.setExecutionControl( parseExecutionControl( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return cacheConfig;
    } //-- CacheConfig parseCacheConfig( XmlPullParser, boolean )

    /**
     * Method parseConfiguration.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Configuration
     */
    private Configuration parseConfiguration( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Configuration configuration = new Configuration();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "enabled", null, parsed ) )
            {
                configuration.setEnabled( getBooleanValue( interpolatedTrimmed( parser.nextText(), "enabled" ), "enabled", parser, "true" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "hashAlgorithm", null, parsed ) )
            {
                configuration.setHashAlgorithm( interpolatedTrimmed( parser.nextText(), "hashAlgorithm" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "validateXml", null, parsed ) )
            {
                configuration.setValidateXml( getBooleanValue( interpolatedTrimmed( parser.nextText(), "validateXml" ), "validateXml", parser, "false" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "multiModule", null, parsed ) )
            {
                configuration.setMultiModule( parseMultiModule( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "projectVersioning", null, parsed ) )
            {
                configuration.setProjectVersioning( parseProjectVersioning( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "remote", null, parsed ) )
            {
                configuration.setRemote( parseRemote( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "attachedOutputs", null, parsed ) )
            {
                configuration.setAttachedOutputs( parseAttachedOutputs( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "local", null, parsed ) )
            {
                configuration.setLocal( parseLocal( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "debugs", null, parsed ) )
            {
                java.util.List<String> debugs = new java.util.ArrayList<String>();
                configuration.setDebugs( debugs );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "debug".equals( parser.getName() ) )
                    {
                        debugs.add( interpolatedTrimmed( parser.nextText(), "debugs" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return configuration;
    } //-- Configuration parseConfiguration( XmlPullParser, boolean )

    /**
     * Method parseCoordinatesBase.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CoordinatesBase
     */
    private CoordinatesBase parseCoordinatesBase( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        CoordinatesBase coordinatesBase = new CoordinatesBase();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "groupId".equals( name ) )
            {
                coordinatesBase.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                coordinatesBase.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return coordinatesBase;
    } //-- CoordinatesBase parseCoordinatesBase( XmlPullParser, boolean )

    /**
     * Method parseDirScanConfig.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DirScanConfig
     */
    private DirScanConfig parseDirScanConfig( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DirScanConfig dirScanConfig = new DirScanConfig();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "ignoreParent".equals( name ) )
            {
                dirScanConfig.setIgnoreParent( getBooleanValue( interpolatedTrimmed( value, "ignoreParent" ), "ignoreParent", parser, "false" ) );
            }
            else if ( "mode".equals( name ) )
            {
                dirScanConfig.setMode( interpolatedTrimmed( value, "mode" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<TagScanConfig> includes = new java.util.ArrayList<TagScanConfig>();
                dirScanConfig.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( parseTagScanConfig( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<TagExclude> excludes = new java.util.ArrayList<TagExclude>();
                dirScanConfig.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( parseTagExclude( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "tagScanConfigs", null, parsed ) )
            {
                java.util.List<TagScanConfig> tagScanConfigs = new java.util.ArrayList<TagScanConfig>();
                dirScanConfig.setTagScanConfigs( tagScanConfigs );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "tagScanConfig".equals( parser.getName() ) )
                    {
                        tagScanConfigs.add( parseTagScanConfig( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return dirScanConfig;
    } //-- DirScanConfig parseDirScanConfig( XmlPullParser, boolean )

    /**
     * Method parseDiscovery.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Discovery
     */
    private Discovery parseDiscovery( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Discovery discovery = new Discovery();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "scanProfiles", null, parsed ) )
            {
                java.util.List<String> scanProfiles = new java.util.ArrayList<String>();
                discovery.setScanProfiles( scanProfiles );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "scanProfile".equals( parser.getName() ) )
                    {
                        scanProfiles.add( interpolatedTrimmed( parser.nextText(), "scanProfiles" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return discovery;
    } //-- Discovery parseDiscovery( XmlPullParser, boolean )

    /**
     * Method parseEffectivePom.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return EffectivePom
     */
    private EffectivePom parseEffectivePom( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        EffectivePom effectivePom = new EffectivePom();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "excludeProperties", null, parsed ) )
            {
                java.util.List<String> excludeProperties = new java.util.ArrayList<String>();
                effectivePom.setExcludeProperties( excludeProperties );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "excludeProperty".equals( parser.getName() ) )
                    {
                        excludeProperties.add( interpolatedTrimmed( parser.nextText(), "excludeProperties" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return effectivePom;
    } //-- EffectivePom parseEffectivePom( XmlPullParser, boolean )

    /**
     * Method parseExclude.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Exclude
     */
    private Exclude parseExclude( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Exclude exclude = new Exclude();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        exclude.setValue( interpolatedTrimmed( parser.nextText(), "value" ) );
        return exclude;
    } //-- Exclude parseExclude( XmlPullParser, boolean )

    /**
     * Method parseExecutables.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Executables
     */
    private Executables parseExecutables( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Executables executables = new Executables();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "plugins", null, parsed ) )
            {
                java.util.List<PluginSet> plugins = new java.util.ArrayList<PluginSet>();
                executables.setPlugins( plugins );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "plugin".equals( parser.getName() ) )
                    {
                        plugins.add( parsePluginSet( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "executions", null, parsed ) )
            {
                java.util.List<ExecutionIdsList> executions = new java.util.ArrayList<ExecutionIdsList>();
                executables.setExecutions( executions );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "execution".equals( parser.getName() ) )
                    {
                        executions.add( parseExecutionIdsList( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "goalsLists", null, parsed ) )
            {
                java.util.List<GoalsList> goalsLists = new java.util.ArrayList<GoalsList>();
                executables.setGoalsLists( goalsLists );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "goalsList".equals( parser.getName() ) )
                    {
                        goalsLists.add( parseGoalsList( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return executables;
    } //-- Executables parseExecutables( XmlPullParser, boolean )

    /**
     * Method parseExecutionConfigurationScan.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ExecutionConfigurationScan
     */
    private ExecutionConfigurationScan parseExecutionConfigurationScan( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ExecutionConfigurationScan executionConfigurationScan = new ExecutionConfigurationScan();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "ignoreParentConfig".equals( name ) )
            {
                executionConfigurationScan.setIgnoreParentConfig( getBooleanValue( interpolatedTrimmed( value, "ignoreParentConfig" ), "ignoreParentConfig", parser, "false" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "execIds", null, parsed ) )
            {
                java.util.List<String> execIds = new java.util.ArrayList<String>();
                executionConfigurationScan.setExecIds( execIds );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "execId".equals( parser.getName() ) )
                    {
                        execIds.add( interpolatedTrimmed( parser.nextText(), "execIds" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "dirScan", null, parsed ) )
            {
                executionConfigurationScan.setDirScan( parseDirScanConfig( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return executionConfigurationScan;
    } //-- ExecutionConfigurationScan parseExecutionConfigurationScan( XmlPullParser, boolean )

    /**
     * Method parseExecutionControl.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ExecutionControl
     */
    private ExecutionControl parseExecutionControl( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ExecutionControl executionControl = new ExecutionControl();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "runAlways", null, parsed ) )
            {
                executionControl.setRunAlways( parseExecutables( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "ignoreMissing", null, parsed ) )
            {
                executionControl.setIgnoreMissing( parseExecutables( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "reconcile", null, parsed ) )
            {
                executionControl.setReconcile( parseReconcile( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return executionControl;
    } //-- ExecutionControl parseExecutionControl( XmlPullParser, boolean )

    /**
     * Method parseExecutionIdsList.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ExecutionIdsList
     */
    private ExecutionIdsList parseExecutionIdsList( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ExecutionIdsList executionIdsList = new ExecutionIdsList();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "groupId".equals( name ) )
            {
                executionIdsList.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                executionIdsList.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "execIds", null, parsed ) )
            {
                java.util.List<String> execIds = new java.util.ArrayList<String>();
                executionIdsList.setExecIds( execIds );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "execId".equals( parser.getName() ) )
                    {
                        execIds.add( interpolatedTrimmed( parser.nextText(), "execIds" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return executionIdsList;
    } //-- ExecutionIdsList parseExecutionIdsList( XmlPullParser, boolean )

    /**
     * Method parseGoalId.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return GoalId
     */
    private GoalId parseGoalId( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        GoalId goalId = new GoalId();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "goal".equals( name ) )
            {
                goalId.setGoal( interpolatedTrimmed( value, "goal" ) );
            }
            else if ( "groupId".equals( name ) )
            {
                goalId.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                goalId.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return goalId;
    } //-- GoalId parseGoalId( XmlPullParser, boolean )

    /**
     * Method parseGoalReconciliation.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return GoalReconciliation
     */
    private GoalReconciliation parseGoalReconciliation( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        GoalReconciliation goalReconciliation = new GoalReconciliation();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "goal".equals( name ) )
            {
                goalReconciliation.setGoal( interpolatedTrimmed( value, "goal" ) );
            }
            else if ( "groupId".equals( name ) )
            {
                goalReconciliation.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                goalReconciliation.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "reconciles", null, parsed ) )
            {
                java.util.List<TrackedProperty> reconciles = new java.util.ArrayList<TrackedProperty>();
                goalReconciliation.setReconciles( reconciles );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "reconcile".equals( parser.getName() ) )
                    {
                        reconciles.add( parseTrackedProperty( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "logs", null, parsed ) )
            {
                java.util.List<PropertyName> logs = new java.util.ArrayList<PropertyName>();
                goalReconciliation.setLogs( logs );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "log".equals( parser.getName() ) )
                    {
                        logs.add( parsePropertyName( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "nologs", null, parsed ) )
            {
                java.util.List<PropertyName> nologs = new java.util.ArrayList<PropertyName>();
                goalReconciliation.setNologs( nologs );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "nolog".equals( parser.getName() ) )
                    {
                        nologs.add( parsePropertyName( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "logAll", null, parsed ) )
            {
                goalReconciliation.setLogAll( getBooleanValue( interpolatedTrimmed( parser.nextText(), "logAll" ), "logAll", parser, "true" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return goalReconciliation;
    } //-- GoalReconciliation parseGoalReconciliation( XmlPullParser, boolean )

    /**
     * Method parseGoalsList.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return GoalsList
     */
    private GoalsList parseGoalsList( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        GoalsList goalsList = new GoalsList();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "groupId".equals( name ) )
            {
                goalsList.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                goalsList.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "goals", null, parsed ) )
            {
                java.util.List<String> goals = new java.util.ArrayList<String>();
                goalsList.setGoals( goals );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "goal".equals( parser.getName() ) )
                    {
                        goals.add( interpolatedTrimmed( parser.nextText(), "goals" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return goalsList;
    } //-- GoalsList parseGoalsList( XmlPullParser, boolean )

    /**
     * Method parseInclude.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Include
     */
    private Include parseInclude( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Include include = new Include();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "recursive".equals( name ) )
            {
                include.setRecursive( getBooleanValue( interpolatedTrimmed( value, "recursive" ), "recursive", parser, "true" ) );
            }
            else if ( "glob".equals( name ) )
            {
                include.setGlob( interpolatedTrimmed( value, "glob" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        include.setValue( interpolatedTrimmed( parser.nextText(), "value" ) );
        return include;
    } //-- Include parseInclude( XmlPullParser, boolean )

    /**
     * Method parseInput.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Input
     */
    private Input parseInput( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Input input = new Input();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "global", null, parsed ) )
            {
                input.setGlobal( parsePathSet( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "plugins", null, parsed ) )
            {
                java.util.List<PluginConfigurationScan> plugins = new java.util.ArrayList<PluginConfigurationScan>();
                input.setPlugins( plugins );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "plugin".equals( parser.getName() ) )
                    {
                        plugins.add( parsePluginConfigurationScan( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return input;
    } //-- Input parseInput( XmlPullParser, boolean )

    /**
     * Method parseLocal.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Local
     */
    private Local parseLocal( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Local local = new Local();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "location", null, parsed ) )
            {
                local.setLocation( interpolatedTrimmed( parser.nextText(), "location" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "maxBuildsCached", null, parsed ) )
            {
                local.setMaxBuildsCached( getIntegerValue( interpolatedTrimmed( parser.nextText(), "maxBuildsCached" ), "maxBuildsCached", parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return local;
    } //-- Local parseLocal( XmlPullParser, boolean )

    /**
     * Method parseMultiModule.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return MultiModule
     */
    private MultiModule parseMultiModule( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        MultiModule multiModule = new MultiModule();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "discovery", null, parsed ) )
            {
                multiModule.setDiscovery( parseDiscovery( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return multiModule;
    } //-- MultiModule parseMultiModule( XmlPullParser, boolean )

    /**
     * Method parseOutput.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Output
     */
    private Output parseOutput( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Output output = new Output();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "exclude", null, parsed ) )
            {
                output.setExclude( parseOutputExclude( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return output;
    } //-- Output parseOutput( XmlPullParser, boolean )

    /**
     * Method parseOutputExclude.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return OutputExclude
     */
    private OutputExclude parseOutputExclude( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        OutputExclude outputExclude = new OutputExclude();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "patterns", null, parsed ) )
            {
                java.util.List<String> patterns = new java.util.ArrayList<String>();
                outputExclude.setPatterns( patterns );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "pattern".equals( parser.getName() ) )
                    {
                        patterns.add( interpolatedTrimmed( parser.nextText(), "patterns" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return outputExclude;
    } //-- OutputExclude parseOutputExclude( XmlPullParser, boolean )

    /**
     * Method parsePathSet.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PathSet
     */
    private PathSet parsePathSet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PathSet pathSet = new PathSet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "glob", null, parsed ) )
            {
                pathSet.setGlob( interpolatedTrimmed( parser.nextText(), "glob" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "includes", null, parsed ) )
            {
                java.util.List<Include> includes = new java.util.ArrayList<Include>();
                pathSet.setIncludes( includes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "include".equals( parser.getName() ) )
                    {
                        includes.add( parseInclude( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "excludes", null, parsed ) )
            {
                java.util.List<Exclude> excludes = new java.util.ArrayList<Exclude>();
                pathSet.setExcludes( excludes );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "exclude".equals( parser.getName() ) )
                    {
                        excludes.add( parseExclude( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return pathSet;
    } //-- PathSet parsePathSet( XmlPullParser, boolean )

    /**
     * Method parsePluginConfigurationScan.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginConfigurationScan
     */
    private PluginConfigurationScan parsePluginConfigurationScan( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PluginConfigurationScan pluginConfigurationScan = new PluginConfigurationScan();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "groupId".equals( name ) )
            {
                pluginConfigurationScan.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                pluginConfigurationScan.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "effectivePom", null, parsed ) )
            {
                pluginConfigurationScan.setEffectivePom( parseEffectivePom( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "dirScan", null, parsed ) )
            {
                pluginConfigurationScan.setDirScan( parseDirScanConfig( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "executions", null, parsed ) )
            {
                java.util.List<ExecutionConfigurationScan> executions = new java.util.ArrayList<ExecutionConfigurationScan>();
                pluginConfigurationScan.setExecutions( executions );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "execution".equals( parser.getName() ) )
                    {
                        executions.add( parseExecutionConfigurationScan( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return pluginConfigurationScan;
    } //-- PluginConfigurationScan parsePluginConfigurationScan( XmlPullParser, boolean )

    /**
     * Method parsePluginSet.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PluginSet
     */
    private PluginSet parsePluginSet( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PluginSet pluginSet = new PluginSet();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "groupId".equals( name ) )
            {
                pluginSet.setGroupId( interpolatedTrimmed( value, "groupId" ) );
            }
            else if ( "artifactId".equals( name ) )
            {
                pluginSet.setArtifactId( interpolatedTrimmed( value, "artifactId" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return pluginSet;
    } //-- PluginSet parsePluginSet( XmlPullParser, boolean )

    /**
     * Method parseProjectVersioning.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ProjectVersioning
     */
    private ProjectVersioning parseProjectVersioning( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ProjectVersioning projectVersioning = new ProjectVersioning();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "adjustMetaInf".equals( name ) )
            {
                projectVersioning.setAdjustMetaInf( getBooleanValue( interpolatedTrimmed( value, "adjustMetaInf" ), "adjustMetaInf", parser, "false" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return projectVersioning;
    } //-- ProjectVersioning parseProjectVersioning( XmlPullParser, boolean )

    /**
     * Method parsePropertyName.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PropertyName
     */
    private PropertyName parsePropertyName( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PropertyName propertyName = new PropertyName();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "propertyName".equals( name ) )
            {
                propertyName.setPropertyName( interpolatedTrimmed( value, "propertyName" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        propertyName.setValue( interpolatedTrimmed( parser.nextText(), "value" ) );
        return propertyName;
    } //-- PropertyName parsePropertyName( XmlPullParser, boolean )

    /**
     * Method parseReconcile.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Reconcile
     */
    private Reconcile parseReconcile( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Reconcile reconcile = new Reconcile();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "logAllProperties".equals( name ) )
            {
                reconcile.setLogAllProperties( getBooleanValue( interpolatedTrimmed( value, "logAllProperties" ), "logAllProperties", parser, "true" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "plugins", null, parsed ) )
            {
                java.util.List<GoalReconciliation> plugins = new java.util.ArrayList<GoalReconciliation>();
                reconcile.setPlugins( plugins );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "plugin".equals( parser.getName() ) )
                    {
                        plugins.add( parseGoalReconciliation( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return reconcile;
    } //-- Reconcile parseReconcile( XmlPullParser, boolean )

    /**
     * Method parseRemote.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Remote
     */
    private Remote parseRemote( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Remote remote = new Remote();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "enabled".equals( name ) )
            {
                remote.setEnabled( getBooleanValue( interpolatedTrimmed( value, "enabled" ), "enabled", parser, "true" ) );
            }
            else if ( "saveToRemote".equals( name ) )
            {
                remote.setSaveToRemote( getBooleanValue( interpolatedTrimmed( value, "saveToRemote" ), "saveToRemote", parser, "false" ) );
            }
            else if ( "transport".equals( name ) )
            {
                remote.setTransport( interpolatedTrimmed( value, "transport" ) );
            }
            else if ( "id".equals( name ) )
            {
                remote.setId( interpolatedTrimmed( value, "id" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "url", null, parsed ) )
            {
                remote.setUrl( interpolatedTrimmed( parser.nextText(), "url" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return remote;
    } //-- Remote parseRemote( XmlPullParser, boolean )

    /**
     * Method parseTagExclude.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return TagExclude
     */
    private TagExclude parseTagExclude( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        TagExclude tagExclude = new TagExclude();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "tagName".equals( name ) )
            {
                tagExclude.setTagName( interpolatedTrimmed( value, "tagName" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return tagExclude;
    } //-- TagExclude parseTagExclude( XmlPullParser, boolean )

    /**
     * Method parseTagScanConfig.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return TagScanConfig
     */
    private TagScanConfig parseTagScanConfig( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        TagScanConfig tagScanConfig = new TagScanConfig();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "recursive".equals( name ) )
            {
                tagScanConfig.setRecursive( getBooleanValue( interpolatedTrimmed( value, "recursive" ), "recursive", parser, "true" ) );
            }
            else if ( "glob".equals( name ) )
            {
                tagScanConfig.setGlob( interpolatedTrimmed( value, "glob" ) );
            }
            else if ( "tagName".equals( name ) )
            {
                tagScanConfig.setTagName( interpolatedTrimmed( value, "tagName" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return tagScanConfig;
    } //-- TagScanConfig parseTagScanConfig( XmlPullParser, boolean )

    /**
     * Method parseTrackedProperty.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return TrackedProperty
     */
    private TrackedProperty parseTrackedProperty( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        TrackedProperty trackedProperty = new TrackedProperty();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "propertyName".equals( name ) )
            {
                trackedProperty.setPropertyName( interpolatedTrimmed( value, "propertyName" ) );
            }
            else if ( "skipValue".equals( name ) )
            {
                trackedProperty.setSkipValue( interpolatedTrimmed( value, "skipValue" ) );
            }
            else if ( "defaultValue".equals( name ) )
            {
                trackedProperty.setDefaultValue( interpolatedTrimmed( value, "defaultValue" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        trackedProperty.setValue( interpolatedTrimmed( parser.nextText(), "value" ) );
        return trackedProperty;
    } //-- TrackedProperty parseTrackedProperty( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CacheConfig
     */
    private CacheConfig read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        CacheConfig cacheConfig = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "cache".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'cache' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'cache'", parser, null );
                }
                cacheConfig = parseCacheConfig( parser, strict );
                cacheConfig.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return cacheConfig;
        }
        throw new XmlPullParserException( "Expected root element 'cache' but found no element at all: invalid XML document", parser, null );
    } //-- CacheConfig read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
