// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.0.0,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.buildcache.xml.build.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.buildcache.xml.build.Build;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.build.PropertyValue;
import org.apache.maven.buildcache.xml.build.Scm;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class BuildCacheBuildXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class BuildCacheBuildXpp3Writer
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private static final String NAMESPACE = null;

    /**
     * Field fileComment.
     */
    private String fileComment = null;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method setFileComment.
     * 
     * @param fileComment a fileComment object.
     */
    public void setFileComment( String fileComment )
    {
        this.fileComment = fileComment;
    } //-- void setFileComment( String )

    /**
     * Method write.
     * 
     * @param writer a writer object.
     * @param build a build object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( Writer writer, Build build )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( build.getModelEncoding(), null );
        writeBuild( build, "build", serializer );
        serializer.endDocument();
    } //-- void write( Writer, Build )

    /**
     * Method write.
     * 
     * @param stream a stream object.
     * @param build a build object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( OutputStream stream, Build build )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( stream, build.getModelEncoding() );
        serializer.startDocument( build.getModelEncoding(), null );
        writeBuild( build, "build", serializer );
        serializer.endDocument();
    } //-- void write( OutputStream, Build )

    /**
     * Method writeArtifact.
     * 
     * @param artifact a artifact object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeArtifact( Artifact artifact, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( artifact.getGroupId() != null )
        {
            serializer.startTag( NAMESPACE, "groupId" ).text( artifact.getGroupId() ).endTag( NAMESPACE, "groupId" );
        }
        if ( artifact.getArtifactId() != null )
        {
            serializer.startTag( NAMESPACE, "artifactId" ).text( artifact.getArtifactId() ).endTag( NAMESPACE, "artifactId" );
        }
        if ( artifact.getVersion() != null )
        {
            serializer.startTag( NAMESPACE, "version" ).text( artifact.getVersion() ).endTag( NAMESPACE, "version" );
        }
        if ( artifact.getClassifier() != null )
        {
            serializer.startTag( NAMESPACE, "classifier" ).text( artifact.getClassifier() ).endTag( NAMESPACE, "classifier" );
        }
        if ( artifact.getType() != null )
        {
            serializer.startTag( NAMESPACE, "type" ).text( artifact.getType() ).endTag( NAMESPACE, "type" );
        }
        if ( artifact.getScope() != null )
        {
            serializer.startTag( NAMESPACE, "scope" ).text( artifact.getScope() ).endTag( NAMESPACE, "scope" );
        }
        if ( artifact.getFileName() != null )
        {
            serializer.startTag( NAMESPACE, "fileName" ).text( artifact.getFileName() ).endTag( NAMESPACE, "fileName" );
        }
        if ( artifact.getFileHash() != null )
        {
            serializer.startTag( NAMESPACE, "fileHash" ).text( artifact.getFileHash() ).endTag( NAMESPACE, "fileHash" );
        }
        if ( artifact.getFileSize() != 0L )
        {
            serializer.startTag( NAMESPACE, "fileSize" ).text( String.valueOf( artifact.getFileSize() ) ).endTag( NAMESPACE, "fileSize" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeArtifact( Artifact, String, XmlSerializer )

    /**
     * Method writeBuild.
     * 
     * @param build a build object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeBuild( Build build, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( this.fileComment != null )
        {
        serializer.comment(this.fileComment);
        }
        serializer.setPrefix( "", "http://maven.apache.org/BUILD-CACHE-BUILD/1.0.0" );
        serializer.setPrefix( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        serializer.startTag( NAMESPACE, tagName );
        serializer.attribute( "", "xsi:schemaLocation", "http://maven.apache.org/BUILD-CACHE-BUILD/1.0.0 https://maven.apache.org/xsd/build-cache-build-1.0.0.xsd" );
        if ( build.getCacheImplementationVersion() != null )
        {
            serializer.startTag( NAMESPACE, "cacheImplementationVersion" ).text( build.getCacheImplementationVersion() ).endTag( NAMESPACE, "cacheImplementationVersion" );
        }
        if ( build.is_final() != null )
        {
            serializer.startTag( NAMESPACE, "final" ).text( String.valueOf( build.is_final() ) ).endTag( NAMESPACE, "final" );
        }
        if ( build.getHashFunction() != null )
        {
            serializer.startTag( NAMESPACE, "hashFunction" ).text( build.getHashFunction() ).endTag( NAMESPACE, "hashFunction" );
        }
        if ( build.getBuildTime() != null )
        {
            serializer.startTag( NAMESPACE, "buildTime" ).text( new java.text.SimpleDateFormat( "yyyy-MM-dd'T'HH:mm:ss.SSS", java.util.Locale.US ).format( build.getBuildTime() ) ).endTag( NAMESPACE, "buildTime" );
        }
        if ( build.getBuildServer() != null )
        {
            serializer.startTag( NAMESPACE, "buildServer" ).text( build.getBuildServer() ).endTag( NAMESPACE, "buildServer" );
        }
        if ( build.getScm() != null )
        {
            writeScm( (Scm) build.getScm(), "scm", serializer );
        }
        if ( ( build.getGoals() != null ) && ( build.getGoals().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "goals" );
            for ( Iterator iter = build.getGoals().iterator(); iter.hasNext(); )
            {
                String goal = (String) iter.next();
                serializer.startTag( NAMESPACE, "goal" ).text( goal ).endTag( NAMESPACE, "goal" );
            }
            serializer.endTag( NAMESPACE, "goals" );
        }
        if ( build.getArtifact() != null )
        {
            writeArtifact( (Artifact) build.getArtifact(), "artifact", serializer );
        }
        if ( ( build.getAttachedArtifacts() != null ) && ( build.getAttachedArtifacts().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "attachedArtifacts" );
            for ( Iterator iter = build.getAttachedArtifacts().iterator(); iter.hasNext(); )
            {
                Artifact o = (Artifact) iter.next();
                writeArtifact( o, "attachedArtifact", serializer );
            }
            serializer.endTag( NAMESPACE, "attachedArtifacts" );
        }
        if ( ( build.getExecutions() != null ) && ( build.getExecutions().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "executions" );
            for ( Iterator iter = build.getExecutions().iterator(); iter.hasNext(); )
            {
                CompletedExecution o = (CompletedExecution) iter.next();
                writeCompletedExecution( o, "execution", serializer );
            }
            serializer.endTag( NAMESPACE, "executions" );
        }
        if ( build.getProjectsInputInfo() != null )
        {
            writeProjectsInputInfo( (ProjectsInputInfo) build.getProjectsInputInfo(), "projectsInputInfo", serializer );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeBuild( Build, String, XmlSerializer )

    /**
     * Method writeCompletedExecution.
     * 
     * @param completedExecution a completedExecution object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeCompletedExecution( CompletedExecution completedExecution, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( completedExecution.getExecutionKey() != null )
        {
            serializer.startTag( NAMESPACE, "executionKey" ).text( completedExecution.getExecutionKey() ).endTag( NAMESPACE, "executionKey" );
        }
        if ( completedExecution.getMojoClassName() != null )
        {
            serializer.startTag( NAMESPACE, "mojoClassName" ).text( completedExecution.getMojoClassName() ).endTag( NAMESPACE, "mojoClassName" );
        }
        if ( ( completedExecution.getProperties() != null ) && ( completedExecution.getProperties().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "properties" );
            for ( Iterator iter = completedExecution.getProperties().iterator(); iter.hasNext(); )
            {
                PropertyValue o = (PropertyValue) iter.next();
                writePropertyValue( o, "property", serializer );
            }
            serializer.endTag( NAMESPACE, "properties" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeCompletedExecution( CompletedExecution, String, XmlSerializer )

    /**
     * Method writeDigestItem.
     * 
     * @param digestItem a digestItem object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeDigestItem( DigestItem digestItem, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( digestItem.getType() != null )
        {
            serializer.attribute( NAMESPACE, "type", digestItem.getType() );
        }
        if ( digestItem.getHash() != null )
        {
            serializer.attribute( NAMESPACE, "hash", digestItem.getHash() );
        }
        if ( digestItem.getFileChecksum() != null )
        {
            serializer.attribute( NAMESPACE, "fileChecksum", digestItem.getFileChecksum() );
        }
        if ( digestItem.getContent() != null )
        {
            serializer.attribute( NAMESPACE, "content", digestItem.getContent() );
        }
        if ( digestItem.getIsText() != null )
        {
            serializer.attribute( NAMESPACE, "isText", digestItem.getIsText() );
        }
        if ( digestItem.getCharset() != null )
        {
            serializer.attribute( NAMESPACE, "charset", digestItem.getCharset() );
        }
        if ( digestItem.getEol() != null )
        {
            serializer.attribute( NAMESPACE, "eol", digestItem.getEol() );
        }
        serializer.text( digestItem.getValue() );
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeDigestItem( DigestItem, String, XmlSerializer )

    /**
     * Method writeProjectsInputInfo.
     * 
     * @param projectsInputInfo a projectsInputInfo object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeProjectsInputInfo( ProjectsInputInfo projectsInputInfo, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( projectsInputInfo.getChecksum() != null )
        {
            serializer.startTag( NAMESPACE, "checksum" ).text( projectsInputInfo.getChecksum() ).endTag( NAMESPACE, "checksum" );
        }
        if ( ( projectsInputInfo.getItems() != null ) && ( projectsInputInfo.getItems().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "items" );
            for ( Iterator iter = projectsInputInfo.getItems().iterator(); iter.hasNext(); )
            {
                DigestItem o = (DigestItem) iter.next();
                writeDigestItem( o, "item", serializer );
            }
            serializer.endTag( NAMESPACE, "items" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeProjectsInputInfo( ProjectsInputInfo, String, XmlSerializer )

    /**
     * Method writePropertyValue.
     * 
     * @param propertyValue a propertyValue object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writePropertyValue( PropertyValue propertyValue, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( propertyValue.getName() != null )
        {
            serializer.attribute( NAMESPACE, "name", propertyValue.getName() );
        }
        if ( propertyValue.isTracked() != null )
        {
            serializer.attribute( NAMESPACE, "tracked", String.valueOf( propertyValue.isTracked() ) );
        }
        serializer.text( propertyValue.getValue() );
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writePropertyValue( PropertyValue, String, XmlSerializer )

    /**
     * Method writeScm.
     * 
     * @param scm a scm object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeScm( Scm scm, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( scm.getSourceBranch() != null )
        {
            serializer.startTag( NAMESPACE, "sourceBranch" ).text( scm.getSourceBranch() ).endTag( NAMESPACE, "sourceBranch" );
        }
        if ( scm.getRevision() != null )
        {
            serializer.startTag( NAMESPACE, "revision" ).text( scm.getRevision() ).endTag( NAMESPACE, "revision" );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeScm( Scm, String, XmlSerializer )

}
