// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.0.0,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.buildcache.xml.build.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.buildcache.xml.build.Build;
import org.apache.maven.buildcache.xml.build.CompletedExecution;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.build.PropertyValue;
import org.apache.maven.buildcache.xml.build.Scm;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class BuildCacheBuildXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class BuildCacheBuildXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public BuildCacheBuildXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.apache.maven.buildcache.xml.build.io.xpp3.BuildCacheBuildXpp3Reader()

    public BuildCacheBuildXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.apache.maven.buildcache.xml.build.io.xpp3.BuildCacheBuildXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Build
     */
    public Build read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- Build read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Build
     */
    public Build read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- Build read( Reader )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Build
     */
    public Build read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- Build read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Build
     */
    public Build read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- Build read( InputStream )

    /**
     * Method parseArtifact.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Artifact
     */
    private Artifact parseArtifact( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Artifact artifact = new Artifact();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                artifact.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                artifact.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                artifact.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "classifier", null, parsed ) )
            {
                artifact.setClassifier( interpolatedTrimmed( parser.nextText(), "classifier" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "type", null, parsed ) )
            {
                artifact.setType( interpolatedTrimmed( parser.nextText(), "type" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "scope", null, parsed ) )
            {
                artifact.setScope( interpolatedTrimmed( parser.nextText(), "scope" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileName", null, parsed ) )
            {
                artifact.setFileName( interpolatedTrimmed( parser.nextText(), "fileName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileHash", null, parsed ) )
            {
                artifact.setFileHash( interpolatedTrimmed( parser.nextText(), "fileHash" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "fileSize", null, parsed ) )
            {
                artifact.setFileSize( getLongValue( interpolatedTrimmed( parser.nextText(), "fileSize" ), "fileSize", parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return artifact;
    } //-- Artifact parseArtifact( XmlPullParser, boolean )

    /**
     * Method parseBuild.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Build
     */
    private Build parseBuild( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Build build = new Build();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "cacheImplementationVersion", null, parsed ) )
            {
                build.setCacheImplementationVersion( interpolatedTrimmed( parser.nextText(), "cacheImplementationVersion" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "final", "final", parsed ) )
            {
                build.set_final( getBooleanValue( interpolatedTrimmed( parser.nextText(), "final" ), "final", parser, "null" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "hashFunction", null, parsed ) )
            {
                build.setHashFunction( interpolatedTrimmed( parser.nextText(), "hashFunction" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "buildTime", null, parsed ) )
            {
                String dateFormat = null;
                build.setBuildTime( getDateValue( interpolatedTrimmed( parser.nextText(), "buildTime" ), "buildTime", dateFormat, parser ) );
            }
            else if ( checkFieldWithDuplicate( parser, "buildServer", null, parsed ) )
            {
                build.setBuildServer( interpolatedTrimmed( parser.nextText(), "buildServer" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "scm", null, parsed ) )
            {
                build.setScm( parseScm( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "goals", null, parsed ) )
            {
                java.util.List<String> goals = new java.util.ArrayList<String>();
                build.setGoals( goals );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "goal".equals( parser.getName() ) )
                    {
                        goals.add( interpolatedTrimmed( parser.nextText(), "goals" ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "artifact", null, parsed ) )
            {
                build.setArtifact( parseArtifact( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "attachedArtifacts", null, parsed ) )
            {
                java.util.List<Artifact> attachedArtifacts = new java.util.ArrayList<Artifact>();
                build.setAttachedArtifacts( attachedArtifacts );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "attachedArtifact".equals( parser.getName() ) )
                    {
                        attachedArtifacts.add( parseArtifact( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "executions", null, parsed ) )
            {
                java.util.List<CompletedExecution> executions = new java.util.ArrayList<CompletedExecution>();
                build.setExecutions( executions );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "execution".equals( parser.getName() ) )
                    {
                        executions.add( parseCompletedExecution( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else if ( checkFieldWithDuplicate( parser, "projectsInputInfo", null, parsed ) )
            {
                build.setProjectsInputInfo( parseProjectsInputInfo( parser, strict ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return build;
    } //-- Build parseBuild( XmlPullParser, boolean )

    /**
     * Method parseCompletedExecution.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return CompletedExecution
     */
    private CompletedExecution parseCompletedExecution( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        CompletedExecution completedExecution = new CompletedExecution();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "executionKey", null, parsed ) )
            {
                completedExecution.setExecutionKey( interpolatedTrimmed( parser.nextText(), "executionKey" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "mojoClassName", null, parsed ) )
            {
                completedExecution.setMojoClassName( interpolatedTrimmed( parser.nextText(), "mojoClassName" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "properties", null, parsed ) )
            {
                java.util.List<PropertyValue> properties = new java.util.ArrayList<PropertyValue>();
                completedExecution.setProperties( properties );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "property".equals( parser.getName() ) )
                    {
                        properties.add( parsePropertyValue( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return completedExecution;
    } //-- CompletedExecution parseCompletedExecution( XmlPullParser, boolean )

    /**
     * Method parseDigestItem.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DigestItem
     */
    private DigestItem parseDigestItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DigestItem digestItem = new DigestItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "type".equals( name ) )
            {
                digestItem.setType( interpolatedTrimmed( value, "type" ) );
            }
            else if ( "hash".equals( name ) )
            {
                digestItem.setHash( interpolatedTrimmed( value, "hash" ) );
            }
            else if ( "fileChecksum".equals( name ) )
            {
                digestItem.setFileChecksum( interpolatedTrimmed( value, "fileChecksum" ) );
            }
            else if ( "content".equals( name ) )
            {
                digestItem.setContent( interpolatedTrimmed( value, "content" ) );
            }
            else if ( "isText".equals( name ) )
            {
                digestItem.setIsText( interpolatedTrimmed( value, "isText" ) );
            }
            else if ( "charset".equals( name ) )
            {
                digestItem.setCharset( interpolatedTrimmed( value, "charset" ) );
            }
            else if ( "eol".equals( name ) )
            {
                digestItem.setEol( interpolatedTrimmed( value, "eol" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        digestItem.setValue( interpolatedTrimmed( parser.nextText(), "value" ) );
        return digestItem;
    } //-- DigestItem parseDigestItem( XmlPullParser, boolean )

    /**
     * Method parseProjectsInputInfo.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return ProjectsInputInfo
     */
    private ProjectsInputInfo parseProjectsInputInfo( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        ProjectsInputInfo projectsInputInfo = new ProjectsInputInfo();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "checksum", null, parsed ) )
            {
                projectsInputInfo.setChecksum( interpolatedTrimmed( parser.nextText(), "checksum" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "items", null, parsed ) )
            {
                java.util.List<DigestItem> items = new java.util.ArrayList<DigestItem>();
                projectsInputInfo.setItems( items );
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "item".equals( parser.getName() ) )
                    {
                        items.add( parseDigestItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return projectsInputInfo;
    } //-- ProjectsInputInfo parseProjectsInputInfo( XmlPullParser, boolean )

    /**
     * Method parsePropertyValue.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PropertyValue
     */
    private PropertyValue parsePropertyValue( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PropertyValue propertyValue = new PropertyValue();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                propertyValue.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "tracked".equals( name ) )
            {
                propertyValue.setTracked( getBooleanValue( interpolatedTrimmed( value, "tracked" ), "tracked", parser, "null" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        propertyValue.setValue( interpolatedTrimmed( parser.nextText(), "value" ) );
        return propertyValue;
    } //-- PropertyValue parsePropertyValue( XmlPullParser, boolean )

    /**
     * Method parseScm.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Scm
     */
    private Scm parseScm( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Scm scm = new Scm();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "sourceBranch", null, parsed ) )
            {
                scm.setSourceBranch( interpolatedTrimmed( parser.nextText(), "sourceBranch" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "revision", null, parsed ) )
            {
                scm.setRevision( interpolatedTrimmed( parser.nextText(), "revision" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return scm;
    } //-- Scm parseScm( XmlPullParser, boolean )

    /**
     * Method read.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Build
     */
    private Build read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        Build build = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "build".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'build' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'build'", parser, null );
                }
                build = parseBuild( parser, strict );
                build.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return build;
        }
        throw new XmlPullParserException( "Expected root element 'build' but found no element at all: invalid XML document", parser, null );
    } //-- Build read( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
