/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.maven.buildcache;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.maven.buildcache.xml.Build;
import org.apache.maven.buildcache.xml.build.Artifact;
import org.apache.maven.project.MavenProject;

/**
 * Remote cache repository.
 */
public interface RemoteCacheRepository extends CacheRepository
{

    String BUILDINFO_XML = "buildinfo.xml";
    String CACHE_REPORT_XML = "build-cache-report.xml";

    /**
     * Download an artifact to the given location.
     * Returns <code>true</code> if success, <code>false</code> if the artifact does not exists
     * and throws an <code>IOException</code> if a problem occurs.
     */
    boolean getArtifactContent( CacheContext context, Artifact artifact, Path target ) throws IOException;

    @Nonnull
    String getResourceUrl( CacheContext context, String filename );

    @Nonnull
    Optional<Build> findBaselineBuild( MavenProject project );
}
