/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.twiki.parser;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.doxia.module.twiki.parser.AbstractFatherBlock;
import org.apache.maven.doxia.module.twiki.parser.Block;
import org.apache.maven.doxia.module.twiki.parser.BlockParser;
import org.apache.maven.doxia.module.twiki.parser.BoldBlock;
import org.apache.maven.doxia.module.twiki.parser.FormatedTextParser;
import org.apache.maven.doxia.module.twiki.parser.TableBlock;
import org.apache.maven.doxia.module.twiki.parser.TableCellBlock;
import org.apache.maven.doxia.module.twiki.parser.TableCellHeaderBlock;
import org.apache.maven.doxia.module.twiki.parser.TableRowBlock;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.util.ByLineSource;

public class TableBlockParser
implements BlockParser {
    private static final Pattern TABLE_PATTERN = Pattern.compile("^\\s*([|].*[|])+\\s*$");
    private FormatedTextParser textParser;

    public final boolean accept(String line) {
        return TABLE_PATTERN.matcher(line).lookingAt();
    }

    public final Block visit(String line, ByLineSource source) throws ParseException {
        if (!this.accept(line)) {
            throw new IllegalAccessError("call accept before this ;)");
        }
        ArrayList<TableRowBlock> rows = new ArrayList<TableRowBlock>();
        String l = line;
        do {
            int rh;
            Matcher m;
            if (!(m = TABLE_PATTERN.matcher(l)).lookingAt()) continue;
            ArrayList<AbstractFatherBlock> cells = new ArrayList<AbstractFatherBlock>();
            int lh = l.indexOf(124) + 1;
            while ((rh = l.indexOf(124, lh)) != -1) {
                Block[] bs = this.textParser.parse(l.substring(lh, rh).trim());
                if (bs.length == 1 && bs[0] instanceof BoldBlock) {
                    Block[] tmp = ((BoldBlock)bs[0]).getBlocks();
                    cells.add(new TableCellHeaderBlock(tmp));
                } else {
                    cells.add(new TableCellBlock(bs));
                }
                lh = rh + 1;
            }
            rows.add(new TableRowBlock(cells.toArray(new Block[0])));
        } while ((l = source.getNextLine()) != null && this.accept(l));
        assert (rows.size() >= 1);
        return new TableBlock(rows.toArray(new Block[0]));
    }

    public final void setTextParser(FormatedTextParser textParser) {
        if (textParser == null) {
            throw new IllegalArgumentException("argument can't be null");
        }
        this.textParser = textParser;
    }
}

