/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.latex;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.maven.doxia.sink.AbstractTextSink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.LineBreaker;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class LatexSink
extends AbstractTextSink {
    private boolean fragmentDocument;
    private boolean ignoreText;
    private LineBreaker out;
    private String sinkCommands;
    private String preamble;
    private boolean titleFlag;
    private int numberedListNesting;
    private boolean verbatimFlag;
    private boolean boxFlag;
    private boolean figureFlag;
    private boolean tableFlag;
    private boolean gridFlag;
    private int[] cellJustif;
    private int cellCount;
    private boolean isTitle;
    private String title;
    private boolean lastCellWasHeader = false;

    protected LatexSink(Writer out) {
        this.out = new LineBreaker(out);
        this.sinkCommands = this.defaultSinkCommands();
        this.preamble = this.defaultPreamble();
    }

    protected LatexSink(Writer out, String sinkCommands, String preamble) {
        this(out, sinkCommands, preamble, false);
    }

    protected LatexSink(Writer out, String sinkCommands, String preamble, boolean fragmentDocument) {
        this.out = new LineBreaker(out);
        this.sinkCommands = sinkCommands;
        this.preamble = preamble;
        this.fragmentDocument = fragmentDocument;
    }

    protected String getDocumentStart() {
        return "\\documentclass[a4paper]{article}" + EOL + EOL;
    }

    protected String getDocumentBegin() {
        return "\\begin{document}" + EOL + EOL;
    }

    protected String getDocumentEnd() {
        return "\\end{document}" + EOL;
    }

    public void head() {
        this.titleFlag = false;
        this.numberedListNesting = 0;
        this.verbatimFlag = false;
        this.boxFlag = false;
        this.figureFlag = false;
        this.tableFlag = false;
        this.gridFlag = false;
        this.cellJustif = null;
        this.cellCount = 0;
        if (!this.fragmentDocument) {
            this.markup(this.sinkCommands);
            this.markup(this.getDocumentStart());
            this.markup(this.preamble);
            this.markup(this.getDocumentBegin());
        }
    }

    public void body() {
        if (this.titleFlag) {
            if (this.fragmentDocument) {
                this.markup("\\section");
            } else {
                this.titleFlag = false;
                this.markup("\\maketitle" + EOL + EOL);
            }
        }
    }

    public void body_() {
        if (!this.fragmentDocument) {
            this.markup(this.getDocumentEnd());
        }
        this.flush();
    }

    public void title() {
        if (!this.fragmentDocument) {
            this.titleFlag = true;
            this.markup("\\title{");
        } else {
            this.ignoreText = true;
        }
    }

    public void title_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void author() {
        if (!this.fragmentDocument) {
            this.markup("\\author{");
        } else {
            this.ignoreText = true;
        }
    }

    public void author_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void date() {
        if (!this.fragmentDocument) {
            this.markup("\\date{");
        } else {
            this.ignoreText = true;
        }
    }

    public void date_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void sectionTitle1() {
        this.isTitle = true;
    }

    public void sectionTitle1_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup(EOL + "\\section{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle2() {
        this.isTitle = true;
    }

    public void sectionTitle2_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup(EOL + "\\subsection{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle3() {
        this.isTitle = true;
    }

    public void sectionTitle3_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup(EOL + "\\subsubsection{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle4() {
        this.isTitle = true;
    }

    public void sectionTitle4_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup(EOL + "\\paragraph{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle5() {
        this.isTitle = true;
    }

    public void sectionTitle5_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup(EOL + "\\subparagraph{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void list() {
        this.markup(EOL + "\\begin{itemize}");
    }

    public void list_() {
        this.markup(EOL + "\\end{itemize}" + EOL);
    }

    public void listItem() {
        this.markup(EOL + "\\item ");
    }

    public void numberedList(int numbering) {
        String style;
        String counter;
        ++this.numberedListNesting;
        switch (this.numberedListNesting) {
            case 1: {
                counter = "enumi";
                break;
            }
            case 2: {
                counter = "enumii";
                break;
            }
            case 3: {
                counter = "enumiii";
                break;
            }
            default: {
                counter = "enumiv";
            }
        }
        switch (numbering) {
            case 2: {
                style = "Alph";
                break;
            }
            case 1: {
                style = "alph";
                break;
            }
            case 4: {
                style = "Roman";
                break;
            }
            case 3: {
                style = "roman";
                break;
            }
            default: {
                style = "arabic";
            }
        }
        this.markup(EOL + "\\begin{enumerate}" + EOL);
        this.markup("\\renewcommand{\\the" + counter + "}{\\" + style + "{" + counter + "}}" + EOL);
    }

    public void numberedList_() {
        this.markup(EOL + "\\end{enumerate}" + EOL);
        --this.numberedListNesting;
    }

    public void numberedListItem() {
        this.markup("\\item ");
    }

    public void definitionList() {
        this.markup(EOL + "\\begin{description}");
    }

    public void definitionList_() {
        this.markup(EOL + "\\end{description}" + EOL);
    }

    public void definedTerm() {
        this.markup(EOL + "\\item[\\mbox{");
    }

    public void definedTerm_() {
        this.markup("}] ");
    }

    public void figure() {
        this.figureFlag = true;
        this.markup(EOL + "\\begin{figure}[htb]" + EOL);
    }

    public void figure_() {
        this.markup("\\end{figure}" + EOL);
        this.figureFlag = false;
    }

    public void figureGraphics(String name) {
        String src = name;
        if (!src.endsWith(".eps")) {
            this.getLog().warn((CharSequence)"[latex-sink] Found non-eps figure graphics!");
        }
        this.markup("\\begin{center}" + EOL);
        this.markup("\\includegraphics{" + src + "}" + EOL);
        this.markup("\\end{center}" + EOL);
    }

    public void figureCaption() {
        this.markup("\\caption{");
    }

    public void figureCaption_() {
        this.markup("}" + EOL);
    }

    public void table() {
        this.tableFlag = true;
        this.markup(EOL + "\\begin{table}[htp]" + EOL);
    }

    public void table_() {
        this.markup("\\end{table}" + EOL);
        this.tableFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        StringBuffer justif = new StringBuffer();
        block5: for (int i = 0; i < justification.length; ++i) {
            if (grid) {
                justif.append('|');
            }
            switch (justification[i]) {
                case 0: {
                    justif.append('c');
                    continue block5;
                }
                case 1: {
                    justif.append('l');
                    continue block5;
                }
                case 2: {
                    justif.append('r');
                }
            }
        }
        if (grid) {
            justif.append('|');
        }
        this.markup("\\begin{center}" + EOL);
        this.markup("\\begin{tabular}{" + justif.toString() + "}" + EOL);
        if (grid) {
            this.markup("\\hline" + EOL);
        }
        this.gridFlag = grid;
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.markup("\\end{tabular}" + EOL);
        this.markup("\\end{center}" + EOL);
        this.gridFlag = false;
        this.cellJustif = null;
    }

    public void tableRow() {
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.markup("\\\\" + EOL);
        if (this.gridFlag || this.lastCellWasHeader) {
            this.markup("\\hline" + EOL);
        }
        this.cellCount = 0;
        this.lastCellWasHeader = false;
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableCell_() {
        this.tableCell_(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    private void tableCell(boolean header) {
        char justif;
        this.lastCellWasHeader = header;
        if (this.cellCount > 0) {
            this.markup(" &" + EOL);
        }
        switch (this.cellJustif[this.cellCount]) {
            case 1: {
                justif = 'l';
                break;
            }
            case 2: {
                justif = 'r';
                break;
            }
            default: {
                justif = 'c';
            }
        }
        this.markup("\\begin{tabular}[t]{" + justif + "}");
    }

    private void tableCell_(boolean header) {
        this.markup("\\end{tabular}");
        ++this.cellCount;
    }

    public void tableCaption() {
        this.markup("\\caption{");
    }

    public void tableCaption_() {
        this.markup("}" + EOL);
    }

    public void paragraph() {
        this.markup(EOL + EOL);
    }

    public void paragraph_() {
        this.markup(EOL);
    }

    public void verbatim(boolean boxed) {
        this.markup(EOL + "\\begin{small}" + EOL);
        if (boxed) {
            this.markup("\\begin{Verbatim}[frame=single]" + EOL);
        } else {
            this.markup("\\begin{Verbatim}" + EOL);
        }
        this.verbatimFlag = true;
        this.boxFlag = boxed;
    }

    public void verbatim_() {
        this.markup(EOL + "\\end{Verbatim}" + EOL);
        this.markup("\\end{small}" + EOL);
        this.verbatimFlag = false;
        this.boxFlag = false;
    }

    public void horizontalRule() {
        this.markup(EOL + "\\begin{center}\\rule[0.5ex]{\\linewidth}{1pt}\\end{center}" + EOL);
    }

    public void pageBreak() {
        this.markup(EOL + "\\newpage" + EOL);
    }

    public void anchor(String name) {
        this.markup("\\hypertarget{" + name + "}{");
    }

    public void anchor_() {
        this.markup("}");
    }

    public void link(String name) {
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.markup("\\href{" + name + "}{");
        } else {
            this.markup("\\hyperlink{" + name + "}{");
        }
    }

    public void link_() {
        this.markup("}");
    }

    public void italic() {
        this.markup("\\textit{");
    }

    public void italic_() {
        this.markup("}");
    }

    public void bold() {
        this.markup("\\textbf{");
    }

    public void bold_() {
        this.markup("}");
    }

    public void monospaced() {
        this.markup("\\texttt{\\small ");
    }

    public void monospaced_() {
        this.markup("}");
    }

    public void lineBreak() {
        this.markup(this.figureFlag || this.tableFlag || this.titleFlag || this.verbatimFlag ? EOL : "\\newline" + EOL);
    }

    public void nonBreakingSpace() {
        this.markup("~");
    }

    public void text(String text) {
        if (this.ignoreText) {
            return;
        }
        if (this.isTitle) {
            this.title = text;
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.getLog().warn((CharSequence)("Unknown Sink event in LatexSink: " + name + ", ignoring!"));
    }

    protected void markup(String text) {
        if (text != null) {
            this.out.write(text, true);
        }
    }

    protected void content(String text) {
        this.out.write(LatexSink.escaped(text), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(text, true);
    }

    public static String escaped(String text) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block14: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '-': 
                case '<': 
                case '>': {
                    buffer.append("\\symbol{").append((int)c).append("}");
                    continue block14;
                }
                case '~': {
                    buffer.append("\\textasciitilde ");
                    continue block14;
                }
                case '^': {
                    buffer.append("\\textasciicircum ");
                    continue block14;
                }
                case '|': {
                    buffer.append("\\textbar ");
                    continue block14;
                }
                case '\\': {
                    buffer.append("\\textbackslash ");
                    continue block14;
                }
                case '$': {
                    buffer.append("\\$");
                    continue block14;
                }
                case '&': {
                    buffer.append("\\&");
                    continue block14;
                }
                case '%': {
                    buffer.append("\\%");
                    continue block14;
                }
                case '#': {
                    buffer.append("\\#");
                    continue block14;
                }
                case '{': {
                    buffer.append("\\{");
                    continue block14;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block14;
                }
                case '_': {
                    buffer.append("\\_");
                    continue block14;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    private static InputStream getDefaultSinkCommands() throws IOException {
        return LatexSink.class.getResource("default_sink_commands.tex").openStream();
    }

    private static InputStream getDefaultPreamble() throws IOException {
        return LatexSink.class.getResource("default_preamble.tex").openStream();
    }

    protected String defaultSinkCommands() {
        String commands = "";
        try {
            commands = IOUtil.toString((InputStream)LatexSink.getDefaultSinkCommands());
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Could not read default LaTeX commands, the generated LaTeX file will not compile!");
            this.getLog().debug((Throwable)ioe);
            return "";
        }
        return commands;
    }

    protected String defaultPreamble() {
        try {
            return IOUtil.toString((InputStream)LatexSink.getDefaultPreamble());
        }
        catch (IOException ioe) {
            this.getLog().warn((CharSequence)"Could not read default LaTeX preamble, the generated LaTeX file will not compile!");
            this.getLog().debug((Throwable)ioe);
            return "";
        }
    }
}

