/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.latex;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.maven.doxia.sink.AbstractTextSink;
import org.apache.maven.doxia.util.LineBreaker;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class LatexSink
extends AbstractTextSink {
    private boolean fragmentDocument;
    private boolean ignoreText;
    private LineBreaker out;
    private String sinkCommands;
    private String preamble;
    private boolean titleFlag;
    private int numberedListNesting;
    private boolean verbatimFlag;
    private boolean boxFlag;
    private boolean figureFlag;
    private boolean tableFlag;
    private boolean gridFlag;
    private int[] cellJustif;
    private int cellCount;
    private boolean isTitle;
    private String title;
    private boolean lastCellWasHeader = false;

    public LatexSink(Writer out) {
        this(out, LatexSink.defaultSinkCommands(), LatexSink.defaultPreamble());
    }

    public LatexSink(Writer out, String sinkCommands, String preamble) {
        this(out, sinkCommands, preamble, false);
    }

    public LatexSink(Writer out, String sinkCommands, String preamble, boolean fragmentDocument) {
        this.out = new LineBreaker(out);
        this.sinkCommands = sinkCommands;
        this.preamble = preamble;
        this.fragmentDocument = fragmentDocument;
    }

    protected String getDocumentStart() {
        return "\\documentclass[a4paper]{article}" + EOL + EOL;
    }

    protected String getDocumentBegin() {
        return "\\begin{document}" + EOL + EOL;
    }

    protected String getDocumentEnd() {
        return "\\end{document}" + EOL;
    }

    public void head() {
        this.titleFlag = false;
        this.numberedListNesting = 0;
        this.verbatimFlag = false;
        this.boxFlag = false;
        this.figureFlag = false;
        this.tableFlag = false;
        this.gridFlag = false;
        this.cellJustif = null;
        this.cellCount = 0;
        if (!this.fragmentDocument) {
            this.markup(this.sinkCommands);
            this.markup(this.getDocumentStart());
            this.markup(this.preamble);
            this.markup(this.getDocumentBegin());
        }
    }

    public void body() {
        if (this.titleFlag) {
            if (this.fragmentDocument) {
                this.markup("\\psection");
            } else {
                this.titleFlag = false;
                this.markup("\\pmaketitle" + EOL + EOL);
            }
        }
    }

    public void body_() {
        if (!this.fragmentDocument) {
            this.markup(this.getDocumentEnd());
        }
        this.flush();
    }

    public void sectionTitle1() {
        this.isTitle = true;
    }

    public void sectionTitle1_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup("\\psectioni{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle2() {
        this.isTitle = true;
    }

    public void sectionTitle2_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup("\\psectionii{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle3() {
        this.isTitle = true;
    }

    public void sectionTitle3_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup("\\psectioniii{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle4() {
        this.isTitle = true;
    }

    public void sectionTitle4_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup("\\psectioniv{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void sectionTitle5() {
        this.isTitle = true;
    }

    public void sectionTitle5_() {
        this.isTitle = false;
        if (StringUtils.isNotEmpty((String)this.title)) {
            this.markup("\\psectionv{" + this.title + "}" + EOL);
            this.title = null;
        }
    }

    public void list() {
        this.markup("\\begin{plist}" + EOL + EOL);
    }

    public void list_() {
        this.markup("\\end{plist}" + EOL + EOL);
    }

    public void listItem() {
        this.markup("\\item{} ");
    }

    public void numberedList(int numbering) {
        String style;
        String counter;
        ++this.numberedListNesting;
        switch (this.numberedListNesting) {
            case 1: {
                counter = "enumi";
                break;
            }
            case 2: {
                counter = "enumii";
                break;
            }
            case 3: {
                counter = "enumiii";
                break;
            }
            default: {
                counter = "enumiv";
            }
        }
        switch (numbering) {
            case 2: {
                style = "Alph";
                break;
            }
            case 1: {
                style = "alph";
                break;
            }
            case 4: {
                style = "Roman";
                break;
            }
            case 3: {
                style = "roman";
                break;
            }
            default: {
                style = "arabic";
            }
        }
        this.markup("\\begin{pnumberedlist}" + EOL);
        this.markup("\\renewcommand{\\the" + counter + "}{\\" + style + "{" + counter + "}}" + EOL + EOL);
    }

    public void numberedList_() {
        this.markup("\\end{pnumberedlist}" + EOL + EOL);
        --this.numberedListNesting;
    }

    public void numberedListItem() {
        this.markup("\\item{} ");
    }

    public void definitionList() {
        this.markup("\\begin{pdefinitionlist}" + EOL + EOL);
    }

    public void definitionList_() {
        this.markup("\\end{pdefinitionlist}" + EOL + EOL);
    }

    public void figure() {
        this.figureFlag = true;
        this.markup("\\begin{pfigure}" + EOL);
    }

    public void figure_() {
        this.markup("\\end{pfigure}" + EOL + EOL);
        this.figureFlag = false;
    }

    public void table() {
        this.tableFlag = true;
        this.markup("\\begin{ptable}" + EOL);
    }

    public void table_() {
        this.markup("\\end{ptable}" + EOL + EOL);
        this.tableFlag = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        StringBuffer justif = new StringBuffer();
        block5: for (int i = 0; i < justification.length; ++i) {
            if (grid) {
                justif.append('|');
            }
            switch (justification[i]) {
                case 0: {
                    justif.append('c');
                    continue block5;
                }
                case 1: {
                    justif.append('l');
                    continue block5;
                }
                case 2: {
                    justif.append('r');
                }
            }
        }
        if (grid) {
            justif.append('|');
        }
        this.markup("\\begin{ptablerows}{" + justif.toString() + "}" + EOL);
        if (grid) {
            this.markup("\\hline" + EOL);
        }
        this.gridFlag = grid;
        this.cellJustif = justification;
    }

    public void tableRows_() {
        this.markup("\\end{ptablerows}" + EOL);
        this.gridFlag = false;
        this.cellJustif = null;
    }

    public void tableRow() {
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.markup("\\\\" + EOL);
        if (this.gridFlag || this.lastCellWasHeader) {
            this.markup("\\hline" + EOL);
        }
        this.cellCount = 0;
        this.lastCellWasHeader = false;
    }

    public void title() {
        if (!this.fragmentDocument) {
            this.titleFlag = true;
            this.markup("\\ptitle{");
        } else {
            this.ignoreText = true;
        }
    }

    public void title_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void author() {
        if (!this.fragmentDocument) {
            this.markup("\\pauthor{");
        } else {
            this.ignoreText = true;
        }
    }

    public void author_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void date() {
        if (!this.fragmentDocument) {
            this.markup("\\pdate{");
        } else {
            this.ignoreText = true;
        }
    }

    public void date_() {
        if (!this.fragmentDocument) {
            this.markup("}" + EOL);
        } else {
            this.ignoreText = false;
        }
    }

    public void sectionTitle_() {
        this.markup("}" + EOL + EOL);
    }

    public void paragraph_() {
        this.markup(EOL + EOL);
    }

    public void verbatim(boolean boxed) {
        if (boxed) {
            this.markup("\\begin{pverbatimbox}" + EOL);
        } else {
            this.markup("\\begin{pverbatim}" + EOL);
        }
        this.markup("\\begin{verbatim}" + EOL);
        this.verbatimFlag = true;
        this.boxFlag = boxed;
    }

    public void verbatim_() {
        this.markup(EOL + "\\end{verbatim}" + EOL);
        if (this.boxFlag) {
            this.markup("\\end{pverbatimbox}" + EOL + EOL);
        } else {
            this.markup("\\end{pverbatim}" + EOL + EOL);
        }
        this.verbatimFlag = false;
        this.boxFlag = false;
    }

    public void definedTerm() {
        this.markup("\\item[\\mbox{");
    }

    public void definedTerm_() {
        this.markup("}] ");
    }

    public void figureCaption() {
        this.markup("\\pfigurecaption{");
    }

    public void figureCaption_() {
        this.markup("}" + EOL);
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableCell_() {
        this.tableCell_(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableHeaderCell_() {
        this.tableCell_(true);
    }

    public void tableCell(boolean header) {
        char justif;
        this.lastCellWasHeader = header;
        if (this.cellCount > 0) {
            this.markup(" &" + EOL);
        }
        switch (this.cellJustif[this.cellCount]) {
            case 1: {
                justif = 'l';
                break;
            }
            case 2: {
                justif = 'r';
                break;
            }
            default: {
                justif = 'c';
            }
        }
        this.markup("\\begin{pcell}{" + justif + "}");
    }

    public void tableCell_(boolean header) {
        this.markup("\\end{pcell}");
        ++this.cellCount;
    }

    public void tableCaption() {
        this.markup("\\ptablecaption{");
    }

    public void tableCaption_() {
        this.markup("}" + EOL);
    }

    public void figureGraphics(String name) {
        this.markup("\\pfiguregraphics{" + name + "}" + EOL);
    }

    public void horizontalRule() {
        this.markup("\\phorizontalrule" + EOL + EOL);
    }

    public void pageBreak() {
        this.markup("\\newpage" + EOL + EOL);
    }

    public void anchor(String name) {
        this.markup("\\panchor{");
    }

    public void anchor_() {
        this.markup("}");
    }

    public void link(String name) {
        this.markup("\\plink{");
    }

    public void link_() {
        this.markup("}");
    }

    public void italic() {
        this.markup("\\pitalic{");
    }

    public void italic_() {
        this.markup("}");
    }

    public void bold() {
        this.markup("\\pbold{");
    }

    public void bold_() {
        this.markup("}");
    }

    public void monospaced() {
        this.markup("\\pmonospaced{");
    }

    public void monospaced_() {
        this.markup("}");
    }

    public void lineBreak() {
        this.markup(this.figureFlag || this.tableFlag || this.titleFlag ? "\\\\" + EOL : "\\newline" + EOL);
    }

    public void nonBreakingSpace() {
        this.markup("~");
    }

    public void text(String text) {
        if (this.ignoreText) {
            return;
        }
        if (this.isTitle) {
            this.title = text;
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    protected void markup(String text) {
        if (text != null) {
            this.out.write(text, true);
        }
    }

    protected void content(String text) {
        this.out.write(LatexSink.escaped(text), false);
    }

    protected void verbatimContent(String text) {
        this.out.write(text, true);
    }

    protected static String escaped(String text) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block14: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '-': 
                case '<': 
                case '>': {
                    buffer.append("\\symbol{").append((int)c).append("}");
                    continue block14;
                }
                case '~': {
                    buffer.append("\\textasciitilde ");
                    continue block14;
                }
                case '^': {
                    buffer.append("\\textasciicircum ");
                    continue block14;
                }
                case '|': {
                    buffer.append("\\textbar ");
                    continue block14;
                }
                case '\\': {
                    buffer.append("\\textbackslash ");
                    continue block14;
                }
                case '$': {
                    buffer.append("\\$");
                    continue block14;
                }
                case '&': {
                    buffer.append("\\&");
                    continue block14;
                }
                case '%': {
                    buffer.append("\\%");
                    continue block14;
                }
                case '#': {
                    buffer.append("\\#");
                    continue block14;
                }
                case '{': {
                    buffer.append("\\{");
                    continue block14;
                }
                case '}': {
                    buffer.append("\\}");
                    continue block14;
                }
                case '_': {
                    buffer.append("\\_");
                    continue block14;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    public static InputStream getDefaultSinkCommands() throws IOException {
        return LatexSink.class.getResource("default_sink_commands.tex").openStream();
    }

    public static InputStream getDefaultPreamble() throws IOException {
        return LatexSink.class.getResource("default_preamble.tex").openStream();
    }

    public static String defaultSinkCommands() {
        String commands = "";
        try {
            commands = IOUtil.toString((InputStream)LatexSink.getDefaultSinkCommands());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return commands;
    }

    public static String defaultPreamble() {
        String preamble = "";
        try {
            preamble = IOUtil.toString((InputStream)LatexSink.getDefaultPreamble());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return preamble;
    }
}

