/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.list;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.doxia.module.confluence.parser.Block;
import org.apache.maven.doxia.module.confluence.parser.ChildBlocksBuilder;
import org.apache.maven.doxia.module.confluence.parser.list.BulletedListBlock;
import org.apache.maven.doxia.module.confluence.parser.list.ListBlock;
import org.apache.maven.doxia.module.confluence.parser.list.ListItemBlock;
import org.apache.maven.doxia.module.confluence.parser.list.NumberedListBlock;
import org.apache.maven.doxia.module.confluence.parser.list.TreeComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeListBuilder {
    private TreeComponent root;
    private TreeComponent current;

    TreeListBuilder() {
        this.current = this.root = new TreeComponent(null, "root", 0);
    }

    void feedEntry(int type, int level, String text) {
        int incomingLevel = level - 1;
        int currentDepth = this.current.getDepth();
        if (incomingLevel != currentDepth) {
            if (incomingLevel > currentDepth) {
                List<TreeComponent> components = this.current.getChildren();
                if (components.size() == 0) {
                    int n = incomingLevel - currentDepth;
                    for (int i = 0; i < n; ++i) {
                        this.current = this.current.addChildren("", type);
                    }
                } else {
                    this.current = components.get(components.size() - 1);
                }
            } else {
                int n = currentDepth - incomingLevel;
                for (int i = 0; i < n; ++i) {
                    this.current = this.current.getFather();
                    if (this.current != null) continue;
                    throw new IllegalStateException();
                }
            }
        }
        this.current.addChildren(text.trim(), type);
    }

    ListBlock getBlock() {
        return this.getList(this.root);
    }

    private ListBlock getList(TreeComponent treeComponent) {
        List<Block> list = this.getListItems(treeComponent);
        int type = treeComponent.getChildren().get(0).getType();
        if (type == 0) {
            return new BulletedListBlock(list);
        }
        return new NumberedListBlock(list);
    }

    private List<Block> getListItems(TreeComponent tc) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (TreeComponent child : tc.getChildren()) {
            ArrayList<Block> childBlocks = new ArrayList<Block>();
            if (child.getFather() != null) {
                childBlocks.addAll(new ChildBlocksBuilder(child.getText()).getBlocks());
            }
            if (child.getChildren().size() != 0) {
                blocks.add(new ListItemBlock(childBlocks, this.getList(child)));
                continue;
            }
            blocks.add(new ListItemBlock(childBlocks));
        }
        return blocks;
    }
}

