package org.apache.maven.doxia.module.confluence;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.doxia.module.site.AbstractSiteModule;

/**
 * @author <a href="mailto:jason@maven.org">Jason van Zyl</a>
 * @version $Id: ConfluenceSiteModule.java 566668 2007-08-16 11:58:32Z vsiveton $
 * @since 1.0
 * @plexus.component role="org.apache.maven.doxia.module.site.SiteModule" role-hint="confluence"
 */
public class ConfluenceSiteModule
    extends AbstractSiteModule
{
    /** {@inheritDoc} */
    public String getSourceDirectory()
    {
        return "confluence";
    }

    /** {@inheritDoc} */
    public String getExtension()
    {
        return "confluence";
    }

    /** {@inheritDoc} */
    public String getParserId()
    {
        return "confluence";
    }
}
