/*
 * $Id$
 */

package org.apache.maven.doxia.docrenderer.document;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * A menu item.
 * 
 * @version $Revision$ $Date$
 */
public class DocumentTOCItem
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The name to use for the toc.
     */
    private String name;

    /**
     * The ref to use for the item.
     */
    private String ref;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method equals.
     * 
     * @param other
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof DocumentTOCItem ) )
        {
            return false;
        }

        DocumentTOCItem that = (DocumentTOCItem) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getRef() == null ? that.getRef() == null : getRef().equals( that.getRef() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the name to use for the toc.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get the ref to use for the item.
     * 
     * @return String
     */
    public String getRef()
    {
        return this.ref;
    } //-- String getRef()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( ref != null ? ref.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Set the name to use for the toc.
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set the ref to use for the item.
     * 
     * @param ref
     */
    public void setRef( String ref )
    {
        this.ref = ref;
    } //-- void setRef( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuffer buf = new StringBuffer();

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "ref = '" );
        buf.append( getRef() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()


}
